/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.util.FileExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class ClasspathUpdater {
    private static final String CMD_REGEDIT = "regedit";
    private static final String FILE_CPREG = "C:\\ClassPath.reg";
    private static final String KEY_CPATH = "\"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\"";
    private AbstractUIProcessHandler m_handler = null;
    private ArrayList<File> m_files = null;
    private String m_installPath = "";

    public void run(AbstractUIProcessHandler oHandler, String[] args) {
        File[] aoFiles;
        this.m_handler = oHandler;
        this.m_files = new ArrayList();
        if (args.length < 1) {
            oHandler.logOutput("Invalid number of arguments. Path to SupportJars expected as argument.", true);
            return;
        }
        oHandler.logOutput("Updating CLASSPATH.", true);
        this.m_installPath = args[0];
        for (File oFile : aoFiles = new File(args[0] + "/SupportJars").listFiles()) {
            String sFile;
            if (!oFile.isFile() || !(sFile = oFile.getName()).endsWith(".jar")) continue;
            this.m_files.add(oFile);
        }
        this.updateClassPath();
    }

    private void addHexClassPath(String sFile, String sEnv, String sHex) throws FileNotFoundException, IOException {
        ArrayList<String> oList = new ArrayList<String>();
        if (sFile == null || sFile.isEmpty()) {
            this.m_handler.logOutput("Invalid filename specified.", true);
            return;
        }
        FileInputStream oIn = new FileInputStream(sFile);
        BufferedReader oRead = new BufferedReader(new InputStreamReader(oIn));
        String sLine = oRead.readLine();
        while (sLine != null) {
            oList.add(sLine);
            sLine = oRead.readLine();
        }
        oRead.close();
        oIn.close();
        File oDel = new File(sFile);
        oDel.delete();
        FileOutputStream oOut = new FileOutputStream(sFile);
        BufferedWriter oWrite = new BufferedWriter(new OutputStreamWriter(oOut));
        Iterator oIt = oList.iterator();
        while (oIt.hasNext()) {
            sLine = (String)oIt.next();
            String sUp = sLine.toUpperCase();
            int iPos = 12;
            if (sUp.indexOf("\"" + sEnv + "\"") == 0) {
                while (oIt.hasNext() && sLine.charAt(sLine.length() - 1) == '\\') {
                    sLine = (String)oIt.next();
                }
                oWrite.write("\"" + sEnv + "\"=");
                for (int i = 0; i < sHex.length(); ++i) {
                    oWrite.write(sHex.charAt(i));
                    if (++iPos <= 78 || sHex.charAt(i) != ',') continue;
                    iPos = 2;
                    oWrite.write("\\\n ");
                }
                oWrite.write("\n");
                continue;
            }
            oWrite.write(sLine + "\n");
        }
        oWrite.flush();
        oWrite.close();
    }

    private void exportRegistry() {
        FileExecutor oExec = new FileExecutor();
        String[] asOut = new String[2];
        String[] asParam = new String[]{CMD_REGEDIT, "/E:A", FILE_CPREG, KEY_CPATH};
        this.m_handler.logOutput("Exporting Registry path to file.", true);
        oExec.executeCommand(asParam, asOut);
    }

    private void importRegistry() {
        FileExecutor oExec = new FileExecutor();
        String[] asOut = new String[2];
        String[] asParam = new String[]{CMD_REGEDIT, "/s", FILE_CPREG};
        this.m_handler.logOutput("Importing Registry path from file.", true);
        oExec.executeCommand(asParam, asOut);
    }

    private String getClassPath() {
        String sPsep = File.pathSeparator;
        String sFsep = File.separator;
        String sPath = "";
        String sFile = "";
        String sComm = "";
        String sBase = "";
        for (File oFile : this.m_files) {
            sFile = oFile.getAbsolutePath();
            if (sFile.toUpperCase().indexOf("LINUX_COMM") > 0) {
                sComm = sFile + sPsep;
                continue;
            }
            sPath = sPath + sFile + sPsep;
        }
        sBase = this.m_installPath + sPsep + this.m_installPath + sFsep + "SupportJars" + sPsep;
        return sBase + sComm + sPath;
    }

    private void updateClassPath() {
        String sFsep = File.separator;
        String sPsep = File.pathSeparator;
        String sEpath = this.m_installPath + sPsep + this.m_installPath + sFsep + "SupportJars" + sPsep;
        String sCpath = this.getClassPath();
        if (File.separatorChar == '\\') {
            this.exportRegistry();
            try {
                this.updateWindowsPath("CLASSPATH", "JAVAPOS_CLASSPATH", sCpath);
                this.updateWindowsPath("PATH", "JAVAPOS_PATH", sEpath);
            }
            catch (FileNotFoundException oFnf) {
                this.m_handler.logOutput("File not found updating windows path. " + oFnf.getLocalizedMessage(), true);
            }
            catch (IOException oIo) {
                this.m_handler.logOutput("I/O exception updating windows path." + oIo.getLocalizedMessage(), true);
            }
            this.importRegistry();
        }
    }

    private void updateWindowsPath(String sEnv, String sDlsEnv, String sPath) throws FileNotFoundException, IOException {
        String sValue;
        int i;
        boolean bFound = false;
        int iPos = 0;
        String sHex = "";
        this.m_handler.logOutput("Replacing value of " + sDlsEnv + " in registry export.", true);
        FileInputStream oIn = new FileInputStream(FILE_CPREG);
        BufferedReader oRead = new BufferedReader(new InputStreamReader(oIn));
        String sLine = oRead.readLine();
        while (sLine != null) {
            String sUp = sLine.toUpperCase();
            if (sUp.startsWith("\"" + sEnv + "\"=")) {
                iPos = sUp.indexOf("=");
                sHex = sUp.substring(iPos + 1);
                if (sHex.indexOf("HEX(2):") != 0) {
                    byte[] abIn = sHex.getBytes();
                    int cPrev = 32;
                    sHex = "hex(2):";
                    for (i = 1; i < abIn.length - 1; ++i) {
                        if (cPrev != 92 || abIn[i] != 92) {
                            sHex = sHex + Integer.toHexString(abIn[i]) + (abIn.length == i - 1 ? "" : ",");
                        }
                        cPrev = (char)abIn[i];
                    }
                    sHex = sHex + "00";
                }
                bFound = true;
                break;
            }
            String sCont = sLine = oRead.readLine();
            while (sCont != null && !sCont.isEmpty() && sCont.charAt(sCont.length() - 1) == '\\') {
                sCont = oRead.readLine();
                if (sCont == null || sCont.isEmpty()) continue;
                sLine = sLine.substring(0, sLine.length() - 1);
                sLine = sLine + sCont.trim();
            }
        }
        oRead.close();
        oIn.close();
        String sDlsHex = "";
        for (int i2 = 0; i2 < sDlsEnv.length(); ++i2) {
            sDlsHex = sDlsHex + Integer.toHexString(sDlsEnv.charAt(i2)) + ",";
        }
        if (bFound) {
            if (sHex.indexOf(sDlsEnv) < 0) {
                String[] asHex = sHex.split(",");
                sHex = "";
                for (int i3 = 0; i3 < asHex.length && !asHex[i3].equals("00"); ++i3) {
                    sHex = sHex + asHex[i3] + ",";
                }
                sHex = sHex + "3b,25," + sDlsHex + "25,00";
                this.addHexClassPath(FILE_CPREG, sEnv, sHex);
            }
        } else {
            String sTarget = "\"" + sEnv + "\"=";
            String sValue2 = sTarget + "hex(2):25," + sDlsHex + "25,00\n";
            StringReplacer oRep = new StringReplacer(FILE_CPREG, sTarget, sValue2, true);
            oRep.findAndReplace();
        }
        byte[] abPath = sPath.getBytes();
        StringBuilder oPath = new StringBuilder();
        for (i = 0; i < abPath.length; ++i) {
            if (abPath[i] == 92) {
                oPath.append("\\\\");
                continue;
            }
            oPath.append((char)abPath[i]);
        }
        sPath = oPath.toString();
        String sTarget = "\"" + sDlsEnv + "\"=";
        StringReplacer oRep = new StringReplacer(FILE_CPREG, sTarget, sValue = sTarget + "\"" + sPath + "\"\n", true);
        if (!oRep.findAndReplace()) {
            this.m_handler.logOutput("Failed to find '" + sTarget + "'", true);
        }
    }
}

