/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.util.FileExecutor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ComportUpdater {
    private static final String CMD_CHMOD = "chmod";
    private static final String CMD_STTY = "stty";
    private static final String FILE_BOOTLOCAL = "/etc/rc.d/boot.local";
    private static final String FILE_RCLOCAL = "/etc/rc.d/rc.local";
    private static final int COM_PORTS = 4;
    private AbstractUIProcessHandler m_handler = null;

    public void run(AbstractUIProcessHandler oHandler, String[] args) {
        String sFile = FILE_BOOTLOCAL;
        StringReplacer oRep = new StringReplacer();
        String[] asOut = new String[2];
        FileExecutor oExec = new FileExecutor();
        this.m_handler = oHandler;
        oHandler.logOutput("Attempting to update /etc/rc.d/boot.local", true);
        File oFile = new File(sFile);
        if (!oFile.exists() || !oFile.canWrite()) {
            sFile = FILE_RCLOCAL;
            oHandler.logOutput("Attempting to update /etc/rc.d/rc.local", true);
        }
        if (!(oFile = new File(sFile)).exists() || !oFile.canWrite()) {
            oHandler.logOutput("Neither boot.local nor rc.local was found.", true);
            return;
        }
        for (int i = 0; i < 4; ++i) {
            String sTty = "/dev/ttyS" + Integer.toString(i);
            oHandler.logOutput("Configuring " + sTty, true);
            String sTarget = "stty --file=" + sTty + " raw";
            String sValue = sTarget + "\n";
            try {
                oRep.findAndReplace(sFile, sTarget, sValue, true);
            }
            catch (FileNotFoundException oFnf) {
                oHandler.logOutput("File not found: " + oFnf.getLocalizedMessage(), true);
                return;
            }
            catch (IOException oIo) {
                oHandler.logOutput("I/O Exception: " + oIo.getLocalizedMessage(), true);
                return;
            }
            String[] asArgs = new String[]{CMD_STTY, "--file=" + sTty, "raw"};
            oExec.executeCommand(asArgs, asOut);
            sTarget = "chmod a+rw " + sTty;
            sValue = sTarget + "\n";
            try {
                oRep.findAndReplace(sFile, sTarget, sValue, true);
            }
            catch (FileNotFoundException oFnf) {
                oHandler.logOutput("File not found: " + oFnf.getLocalizedMessage(), true);
                return;
            }
            catch (IOException oIo) {
                oHandler.logOutput("I/O Exception: " + oIo.getLocalizedMessage(), true);
                return;
            }
            this.chmod(sTty, 666);
        }
        this.chmod(sFile, 755);
    }

    protected void chmod(String sPath, int iPerm) {
        if (sPath == null || sPath.isEmpty()) {
            this.m_handler.logOutput("Invalid path specified. Cannot chmod.", true);
            return;
        }
        File oPath = new File(sPath);
        if (!oPath.exists()) {
            this.m_handler.logOutput("Specified path does not exist: " + sPath, true);
            return;
        }
        String sPerm = Integer.toString(iPerm);
        String[] asParam = new String[]{CMD_CHMOD, sPerm, oPath.getAbsolutePath()};
        String[] asOut = new String[2];
        FileExecutor oExc = new FileExecutor();
        oExc.executeCommand(asParam, asOut);
    }
}

