/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.util.FileExecutor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LibpathUpdater {
    private static final String CMD_CHMOD = "chmod";
    private static final String CMD_EXPORT = "export";
    private static final String FILE_PROFILE = "/etc/profile";
    private static final String VAL_DLSPATH = "DLS_LD_LIBRARY_PATH";
    private static final String VAL_LDPATH = "LD_LIBRARY_PATH";
    private AbstractUIProcessHandler m_handler = null;

    public void run(AbstractUIProcessHandler oHandler, String[] args) {
        if (args.length < 1) {
            oHandler.logOutput("Invalid number of arguments specified.", true);
            return;
        }
        this.m_handler = oHandler;
        oHandler.logOutput("Adding SupportJars folder to path.", true);
        String sPath = args[0] + "/SupportJars";
        StringReplacer oRep = new StringReplacer(FILE_PROFILE, VAL_DLSPATH, "DLS_LD_LIBRARY_PATH=" + sPath + "\n", true);
        try {
            oRep.findAndReplace();
        }
        catch (FileNotFoundException oFnf) {
            oHandler.logOutput("File not found: " + oFnf.getLocalizedMessage(), true);
            return;
        }
        catch (IOException oIo) {
            oHandler.logOutput("I/O Exception: " + oIo.getLocalizedMessage(), true);
            return;
        }
        oHandler.logOutput("Updating LD_LIBRARY_PATH.", true);
        String sArg = "LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$DLS_LD_LIBRARY_PATH";
        oRep.setTarget(sArg);
        oRep.setValue(sArg + "\n");
        try {
            oRep.findAndReplace();
        }
        catch (FileNotFoundException oFnf) {
            oHandler.logOutput("File not found: " + oFnf.getLocalizedMessage(), true);
            return;
        }
        catch (IOException oIo) {
            oHandler.logOutput("I/O Exception: " + oIo.getLocalizedMessage(), true);
            return;
        }
        oHandler.logOutput("Adding command to export LD_LIBRARY_PATH.", true);
        sArg = "export LD_LIBRARY_PATH";
        oRep.setTarget(sArg);
        oRep.setValue(sArg + "\n");
        try {
            oRep.findAndReplace();
        }
        catch (FileNotFoundException oFnf) {
            oHandler.logOutput("File not found: " + oFnf.getLocalizedMessage(), true);
            return;
        }
        catch (IOException oIo) {
            oHandler.logOutput("I/O Exception: " + oIo.getLocalizedMessage(), true);
            return;
        }
    }

    protected void chmod(String sPath, int iPerm) {
        if (sPath == null || sPath.isEmpty()) {
            this.m_handler.logOutput("Invalid path specified. Cannot chmod.", true);
            return;
        }
        File oPath = new File(sPath);
        if (!oPath.exists()) {
            this.m_handler.logOutput("Specified path does not exist: " + sPath, true);
            return;
        }
        String sPerm = Integer.toString(iPerm);
        String[] asParam = new String[]{CMD_CHMOD, sPerm, oPath.getAbsolutePath()};
        String[] asOut = new String[2];
        FileExecutor oExc = new FileExecutor();
        oExc.executeCommand(asParam, asOut);
    }
}

