/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class StringReplacer {
    private String m_filename = "";
    private String m_target = "";
    private String m_value = "";
    private String m_tmpExt = "dls";
    private String m_bakExt = "bak";
    private boolean m_writeAnyways = false;

    public StringReplacer() {
    }

    public StringReplacer(String sFilename, String sTarget, String sValue, boolean bWriteAnyways) {
        this();
        this.m_filename = sFilename;
        this.m_target = sTarget;
        this.m_value = sValue;
        this.m_writeAnyways = bWriteAnyways;
    }

    public boolean findAndReplace() throws FileNotFoundException, IOException {
        boolean bFound = false;
        String sFilename = this.getFilename();
        String sTmp = this.getTempExtension();
        String sBak = this.getBackupExtension();
        String sTarget = this.getTarget();
        String sValue = this.getValue();
        String sNl = System.getProperty("line.separator");
        File oFile = null;
        File oBak = null;
        FileOutputStream oOut = null;
        FileInputStream oIn = null;
        BufferedWriter oWrite = null;
        BufferedReader oRead = null;
        if (sFilename == null || sFilename.isEmpty()) {
            return false;
        }
        oFile = new File(sFilename);
        if (!oFile.exists()) {
            return false;
        }
        oFile = new File(sFilename + "." + sTmp);
        oFile.delete();
        oFile = new File(sFilename + "." + sBak);
        oFile.delete();
        oOut = new FileOutputStream(sFilename + "." + sTmp);
        oWrite = new BufferedWriter(new OutputStreamWriter(oOut));
        oIn = new FileInputStream(sFilename);
        oRead = new BufferedReader(new InputStreamReader(oIn));
        String sLine = oRead.readLine();
        while (sLine != null) {
            if (sLine.indexOf(sTarget) == 0) {
                bFound = true;
                oWrite.write(sValue);
            } else {
                oWrite.write(sLine + sNl);
            }
            sLine = oRead.readLine();
        }
        if (!bFound && this.isWriteAnyways()) {
            oWrite.write(sValue);
            bFound = true;
        }
        oWrite.flush();
        oWrite.close();
        oRead.close();
        if (bFound) {
            oFile = new File(sFilename);
            oBak = new File(sFilename + "." + sBak);
            oFile.renameTo(oBak);
            oFile = new File(sFilename + "." + sTmp);
            oBak = new File(sFilename);
            oFile.renameTo(oBak);
        }
        return bFound;
    }

    public boolean findAndReplace(String sFilename, String sTarget, String sValue, boolean bWriteAnyways) throws FileNotFoundException, IOException {
        this.setFilename(sFilename);
        this.setTarget(sTarget);
        this.setValue(sValue);
        this.setWriteAnyways(bWriteAnyways);
        return this.findAndReplace();
    }

    public String getBackupExtension() {
        return this.m_bakExt;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getTempExtension() {
        return this.m_tmpExt;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean isWriteAnyways() {
        return this.m_writeAnyways;
    }

    public void setBackupExtension(String sExt) {
        this.m_bakExt = sExt;
    }

    public void setFilename(String sFilename) {
        this.m_filename = sFilename;
    }

    public void setTarget(String sTarget) {
        this.m_target = sTarget;
    }

    public void setTempExtension(String sExt) {
        this.m_tmpExt = sExt;
    }

    public void setValue(String sValue) {
        this.m_value = sValue;
    }

    public void setWriteAnyways(boolean bWrite) {
        this.m_writeAnyways = bWrite;
    }
}

