/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.util.FileExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

public class UsbUpdater {
    private static final String CMD_CHMOD = "chmod";
    private static final String CMD_MOUNT = "mount";
    private static final String CMD_UMOUNT = "umount";
    private static final String FILE_SYSINIT = "/etc/rc.d/rc.sysinit";
    private static final String FILE_FSTAB = "/etc/fstab";
    private static final String PATH_USB = "/proc/bus/usb";
    private static final String VAL_USBFS = "usbfs                   /proc/bus/usb           usbfs   noauto,devmode=0666 0 0\n";
    private AbstractUIProcessHandler m_handler = null;

    public void run(AbstractUIProcessHandler oHandler, String[] args) {
        String[] asCmd;
        boolean bFound = false;
        String[] asOut = new String[2];
        FileExecutor oExc = new FileExecutor();
        this.m_handler = oHandler;
        oHandler.logOutput("Updating USB access.", true);
        oHandler.logOutput("Updating /etc/rc.d/rc.sysinit", true);
        this.updateSysInit();
        StringReplacer oRep = new StringReplacer(FILE_FSTAB, "usbfs", VAL_USBFS, false);
        try {
            oRep.findAndReplace();
        }
        catch (FileNotFoundException oFnf) {
            oHandler.logOutput("File not found: " + oFnf.getLocalizedMessage(), true);
            bFound = false;
        }
        catch (IOException oIo) {
            oHandler.logOutput("I/O Exception: " + oIo.getLocalizedMessage(), true);
            bFound = false;
        }
        if (bFound) {
            asCmd = new String[]{CMD_UMOUNT, "usbfs"};
            oExc.executeCommand(asCmd, asOut);
            String[] asMount = new String[]{CMD_MOUNT, "usbfs"};
            oExc.executeCommand(asMount, asOut);
        } else {
            asCmd = new String[]{CMD_UMOUNT, PATH_USB};
            oExc.executeCommand(asCmd, asOut);
            String[] asMount = new String[]{CMD_MOUNT, "-n", "-t", "usbfs", "-o", "devmode=0666", PATH_USB, PATH_USB};
            oExc.executeCommand(asMount, asOut);
        }
        this.chmod(FILE_FSTAB, 644);
    }

    private void updateSysInit() {
        String sLine;
        ArrayList<String> oTarget = new ArrayList<String>();
        FileInputStream oIn = null;
        BufferedReader oReader = null;
        this.m_handler.logOutput("Updating rc.sysinit", true);
        try {
            oIn = new FileInputStream(FILE_SYSINIT);
        }
        catch (FileNotFoundException ex) {
            this.m_handler.logOutput("Could not locate rc.sysinit. " + ex.getLocalizedMessage(), true);
            return;
        }
        oReader = new BufferedReader(new InputStreamReader(oIn));
        try {
            sLine = oReader.readLine();
        }
        catch (IOException ex) {
            this.m_handler.logOutput("Could not read from /etc/rc.d/rc.sysinit: " + ex.getLocalizedMessage(), true);
            return;
        }
        while (sLine != null) {
            if (sLine.contains("mount -n -t usbfs") && !sLine.contains("devmode=0666")) {
                oTarget.add(sLine);
            }
            try {
                sLine = oReader.readLine();
            }
            catch (IOException ex) {
                this.m_handler.logOutput("Error reading from /etc/rc.d/rc.sysinit: " + ex.getLocalizedMessage(), true);
                return;
            }
        }
        int iPos = 0;
        Iterator oIt = oTarget.iterator();
        StringReplacer oRep = null;
        while (oIt.hasNext()) {
            sLine = (String)oIt.next();
            iPos = sLine.indexOf("mount -n -t usbfs");
            if (iPos < 0) continue;
            String sNew = sLine.substring(0, iPos + 18) + "-o devmode=0666 " + sLine.substring(iPos + 18) + "\n";
            oRep = new StringReplacer(FILE_SYSINIT, sLine, sNew, false);
            try {
                oRep.findAndReplace();
            }
            catch (FileNotFoundException oFnf) {
                this.m_handler.logOutput("File not found: " + oFnf.getLocalizedMessage(), true);
            }
            catch (IOException oIo) {
                this.m_handler.logOutput("I/O Exception: " + oIo.getLocalizedMessage(), true);
            }
        }
        this.chmod(FILE_SYSINIT, 755);
    }

    protected void chmod(String sPath, int iPerm) {
        if (sPath == null || sPath.isEmpty()) {
            this.m_handler.logOutput("Invalid path specified. Cannot chmod.", true);
            return;
        }
        File oPath = new File(sPath);
        if (!oPath.exists()) {
            this.m_handler.logOutput("Specified path does not exist: " + sPath, true);
            return;
        }
        String sPerm = Integer.toString(iPerm);
        String[] asParam = new String[]{CMD_CHMOD, sPerm, oPath.getAbsolutePath()};
        String[] asOut = new String[2];
        FileExecutor oExc = new FileExecutor();
        oExc.executeCommand(asParam, asOut);
    }
}

