/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.agent;

import com.datalogic.agent.CommandInfo;
import com.datalogic.agent.GatewayCommManager;
import com.datalogic.agent.api.DeviceStatusReceiver;
import com.datalogic.agent.api.MiddlewareApiClient;
import com.datalogic.agent.api.ScanEventReceiver;
import com.datalogic.agent.api.StorageModuleClient;
import com.datalogic.agent.config.Config;
import com.datalogic.agent.config.ConfigHelper;
import com.datalogic.agent.config.Edge;
import com.datalogic.agent.config.Mqtt;
import com.datalogic.agent.exception.SdsNotFoundException;
import com.datalogic.agent.model.agent.messages.DeviceEdgeMessage;
import com.datalogic.agent.model.agent.messages.HostEdgeMessage;
import com.datalogic.agent.model.agent.messages.InfoTelemetry;
import com.datalogic.agent.model.agent.messages.ScanEvent;
import com.datalogic.agent.model.agent.messages.StatsHealthTelemetry;
import com.datalogic.agent.model.agent.messages.UpdateStatusTelemetry;
import com.datalogic.agent.model.common.Attachment;
import com.datalogic.agent.model.common.CommandStatusCode;
import com.datalogic.agent.model.common.DataType;
import com.datalogic.agent.model.edge.messages.DeviceCommandMqtt;
import com.datalogic.agent.model.edge.messages.DeviceCommandResponse;
import com.datalogic.agent.model.edge.messages.EdgeStatus;
import com.datalogic.agent.model.service.messages.BaseResponse;
import com.datalogic.agent.model.service.messages.ConnectionStatus;
import com.datalogic.agent.model.service.messages.Device;
import com.datalogic.agent.model.service.messages.DeviceConnectionStatus;
import com.datalogic.agent.model.service.messages.DeviceStatusUpdate;
import com.datalogic.agent.model.service.messages.Host;
import com.datalogic.agent.model.service.messages.HostConnectionStatus;
import com.datalogic.agent.model.service.messages.StatusEvent;
import com.datalogic.agent.mqtt.IMqttHelper;
import com.datalogic.agent.mqtt.PahoHelper;
import com.datalogic.agent.utils.ConstKt;
import com.datalogic.agent.utils.Utils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ktor.client.plugins.ClientRequestException;
import io.ktor.client.plugins.ServerResponseException;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.net.ConnectException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001f\u0010\u001b\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J)\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J!\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J!\u0010,\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J!\u0010-\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J!\u0010.\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J!\u0010/\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\b\u00100\u001a\u00020\u0015H\u0002J\u0011\u00101\u001a\u00020\u0013H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u001b\u00102\u001a\u00020\u00152\b\b\u0002\u00103\u001a\u000204H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J \u00106\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u00107\u001a\u000208H\u0002J+\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\t2\u0006\u0010=\u001a\u00020\u0013H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J#\u0010?\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\tH\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J\u0019\u0010?\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJ#\u0010B\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\tH\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J\u0016\u0010C\u001a\u00020\u00152\f\u0010D\u001a\b\u0012\u0004\u0012\u00020;0EH\u0002J\u0019\u0010F\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0013H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0011\u0010H\u001a\u00020\u0015H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0011\u0010I\u001a\u00020\u0015H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010J\u001a\u00020\u00152\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020MH\u0002J\u0018\u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u00020P2\u0006\u0010'\u001a\u00020\tH\u0002J\b\u0010Q\u001a\u00020\u0015H\u0002J\u0010\u0010Q\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\tH\u0002J\u0016\u0010Q\u001a\u00020\u00152\f\u0010D\u001a\b\u0012\u0004\u0012\u00020;0EH\u0002J\b\u0010R\u001a\u00020\u0015H\u0002J\b\u0010S\u001a\u00020\u0015H\u0002J\b\u0010T\u001a\u00020\u0015H\u0002J\b\u0010U\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006V"}, d2={"Lcom/datalogic/agent/GatewayCommManager;", "Lorg/apache/logging/log4j/kotlin/Logging;", "config", "Lcom/datalogic/agent/config/Config;", "(Lcom/datalogic/agent/config/Config;)V", "client", "Lcom/datalogic/agent/api/MiddlewareApiClient;", "commandIdMap", "", "", "Lcom/datalogic/agent/CommandInfo;", "hostname", "lastDeviceDiagnosticSent", "Lcom/datalogic/agent/model/agent/messages/DeviceEdgeMessage;", "lastHostPropSent", "Lcom/datalogic/agent/model/service/messages/Host;", "mqtt", "Lcom/datalogic/agent/mqtt/IMqttHelper;", "sentHostConnected", "", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleCommandRequest", "topic", "message", "", "handleDeviceConnectionStatus", "statusReceived", "Lcom/datalogic/agent/model/service/messages/StatusEvent;", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/datalogic/agent/model/service/messages/StatusEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleException", "e", "", "deviceCommand", "Lcom/datalogic/agent/model/edge/messages/DeviceCommandMqtt;", "handleFirmwareUpgradeStatus", "handleGenericCommand", "deviceId", "commandName", "(Ljava/lang/String;Ljava/lang/String;Lcom/datalogic/agent/model/edge/messages/DeviceCommandMqtt;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleGetConfigCommand", "(Ljava/lang/String;Lcom/datalogic/agent/model/edge/messages/DeviceCommandMqtt;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRefreshConfigDiagnosticCommand", "handleRefreshConfigPropertiesCommand", "handleRefreshConfigTelemetriesCommand", "handleSetConfigCommand", "scheduleSendTelemetryTask", "sendAllDiagnosticsToMqtt", "sendAllTelemetriesWithRetry", "retry", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendCommandProgress", "commandStatusCode", "Lcom/datalogic/agent/model/common/CommandStatusCode;", "sendDeviceDiagnosticToMqtt", "device", "Lcom/datalogic/agent/model/service/messages/Device;", "parentPath", "discardAlreadySentProperties", "(Lcom/datalogic/agent/model/service/messages/Device;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendDevicePropertiesToMqtt", "(Lcom/datalogic/agent/model/service/messages/Device;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendDeviceTelemetriesToMqtt", "sendDisconnectionEventToAllDevices", "deviceList", "", "sendHostDiagnosticToMqtt", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendHostPropertiesToMqtt", "sendHostTelemetriesToMqtt", "sendUpdateStatusConnection", "deviceID", "connectionStatus", "Lcom/datalogic/agent/model/service/messages/ConnectionStatus;", "sendUpdateStatusTelemetry", "updateStatusTelemetry", "Lcom/datalogic/agent/model/agent/messages/UpdateStatusTelemetry;", "subscribeToDeviceCommands", "subscribeToEdgeStatus", "subscribeToHostCommands", "subscribeToScanEvents", "subscribeToStatusEvents", "dl-client-sdk"})
@SourceDebugExtension(value={"SMAP\nGatewayCommManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayCommManager.kt\ncom/datalogic/agent/GatewayCommManager\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,909:1\n55#2:910\n43#2:911\n56#2:912\n43#2:913\n53#2:922\n43#2:923\n1855#3,2:914\n1855#3,2:916\n1855#3,2:918\n1855#3,2:920\n1855#3,2:924\n1855#3,2:926\n1855#3,2:928\n*S KotlinDebug\n*F\n+ 1 GatewayCommManager.kt\ncom/datalogic/agent/GatewayCommManager\n*L\n142#1:910\n142#1:911\n204#1:912\n204#1:913\n305#1:922\n305#1:923\n262#1:914,2\n281#1:916,2\n289#1:918,2\n293#1:920,2\n310#1:924,2\n711#1:926,2\n896#1:928,2\n*E\n"})
public final class GatewayCommManager
implements Logging {
    @NotNull
    private Config config;
    @NotNull
    private final IMqttHelper mqtt;
    @NotNull
    private final MiddlewareApiClient client;
    @NotNull
    private final Map<String, DeviceEdgeMessage> lastDeviceDiagnosticSent;
    @NotNull
    private final Map<String, CommandInfo> commandIdMap;
    @NotNull
    private String hostname;
    @Nullable
    private Host lastHostPropSent;
    private boolean sentHostConnected;

    public GatewayCommManager(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter(config2, "config");
        this.config = config2;
        this.client = new MiddlewareApiClient(this.config.getService().getProtocol(), this.config.getService().getHost(), this.config.getService().getPort());
        this.lastDeviceDiagnosticSent = new ConcurrentHashMap();
        this.commandIdMap = new LinkedHashMap();
        this.hostname = "";
        Mqtt mqttConfig = this.config.getMqtt();
        Edge edgeConfig = this.config.getEdge();
        this.getLogger().info("Configuration applied\n" + this.config);
        this.mqtt = new PahoHelper(mqttConfig.getClientId(), mqttConfig.getProtocol() + "://" + edgeConfig.getHost() + ":" + mqttConfig.getPort(), mqttConfig.getUsername(), mqttConfig.getPassword(), mqttConfig.getCaFilePath(), mqttConfig.getCrtFilePath(), mqttConfig.getKeyFilePath(), 1.INSTANCE);
        this.subscribeToEdgeStatus();
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GatewayCommManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = this.this$0.sendAllTelemetriesWithRetry(3, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        this.scheduleSendTelemetryTask();
        this.subscribeToScanEvents();
        this.subscribeToStatusEvents();
        this.subscribeToHostCommands();
        this.subscribeToDeviceCommands();
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendAllTelemetriesWithRetry(int var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof sendAllTelemetriesWithRetry.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendAllTelemetriesWithRetry(this.this$0, 0, this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                telemetryRetries = 0;
lbl13:
                // 2 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.I$0 = retry;
                    $continuation.I$1 = telemetryRetries;
                    $continuation.label = 1;
                    v0 = this.sendAllDiagnosticsToMqtt($continuation);
                    if (v0 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl28
                    break;
                }
            }
            case 1: {
                telemetryRetries = $continuation.I$1;
                retry = $continuation.I$0;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl28:
                // 2 sources

                if (((Boolean)v0).booleanValue() || telemetryRetries > retry) break;
                this.getLogger().warn("Retrying send telemetries in 30 seconds");
                $continuation.L$0 = this;
                $continuation.I$0 = retry;
                $continuation.I$1 = ++telemetryRetries;
                $continuation.label = 2;
                v1 = DelayKt.delay(30000L, $continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl44
            }
            case 2: {
                telemetryRetries = $continuation.I$1;
                retry = $continuation.I$0;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl44:
                // 2 sources

                ** continue;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object sendAllTelemetriesWithRetry$default(GatewayCommManager gatewayCommManager, int n, Continuation continuation2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return gatewayCommManager.sendAllTelemetriesWithRetry(n, continuation2);
    }

    private final void subscribeToEdgeStatus() {
        this.mqtt.subscribe("edge/status", (Function2<? super String, ? super byte[], Unit>)new Function2<String, byte[], Unit>(this){
            final /* synthetic */ GatewayCommManager this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull byte[] message) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(message, "message");
                ObjectMapper objectMapper = ConstKt.getObjectMapper();
                Intrinsics.checkNotNullExpressionValue(objectMapper, "objectMapper");
                ObjectMapper $this$readValue$iv = objectMapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                EdgeStatus edgeStatus = (EdgeStatus)$this$readValue$iv.readValue(message, (TypeReference)new TypeReference<EdgeStatus>(){});
                if (edgeStatus.getConnected()) {
                    this.this$0.getLogger().info("Edge is now online");
                    BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        final /* synthetic */ GatewayCommManager this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.label = 1;
                                    Object object3 = GatewayCommManager.access$sendAllTelemetriesWithRetry(this.this$0, 2, this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure($result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                } else {
                    this.this$0.getLogger().error("Edge is offline");
                }
            }
        });
    }

    private final void subscribeToScanEvents() {
        new ScanEventReceiver(this.client).start((Function1<? super ScanEvent, Unit>)new Function1<ScanEvent, Unit>(this){
            final /* synthetic */ GatewayCommManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScanEvent scanEvent) {
                Intrinsics.checkNotNullParameter(scanEvent, "scanEvent");
                this.this$0.getLogger().info("Received from device " + scanEvent.getDeviceID() + " scanEvent: " + scanEvent.getSymbology() + " " + scanEvent.getContent());
                IMqttHelper iMqttHelper = GatewayCommManager.access$getMqtt$p(this.this$0);
                String string = "device/" + scanEvent.getDeviceID() + "/scan";
                String string2 = ConstKt.getObjectMapper().writeValueAsString(scanEvent);
                Intrinsics.checkNotNullExpressionValue(string2, "objectMapper.writeValueAsString(scanEvent)");
                IMqttHelper.DefaultImpls.sendMessage$default(iMqttHelper, string, string2, 0, 4, null);
            }
        });
    }

    private final void subscribeToStatusEvents() {
        new DeviceStatusReceiver(this.client).start((Function1<? super StatusEvent<JsonNode>, Unit>)new Function1<StatusEvent<JsonNode>, Unit>(this){
            final /* synthetic */ GatewayCommManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull StatusEvent<JsonNode> statusReceived) {
                Intrinsics.checkNotNullParameter(statusReceived, "statusReceived");
                this.this$0.getLogger().info("Received from device " + statusReceived.getDeviceID() + " statusEventEvent: " + statusReceived.getEventType() + " " + statusReceived.getValue());
                switch (subscribeToStatusEvents.WhenMappings.$EnumSwitchMapping$0[statusReceived.getEventType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        GatewayCommManager.access$handleFirmwareUpgradeStatus(this.this$0, statusReceived);
                        break;
                    }
                    case 4: {
                        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, statusReceived, null){
                            int label;
                            final /* synthetic */ GatewayCommManager this$0;
                            final /* synthetic */ StatusEvent<JsonNode> $statusReceived;
                            {
                                this.this$0 = $receiver;
                                this.$statusReceived = $statusReceived;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        this.label = 1;
                                        Object object3 = GatewayCommManager.access$handleDeviceConnectionStatus(this.this$0, this.$statusReceived, this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure($result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFirmwareUpgradeStatus(StatusEvent<JsonNode> statusReceived) {
        void $this$treeToValue$iv;
        ObjectMapper objectMapper = ConstKt.getObjectMapper();
        Intrinsics.checkNotNullExpressionValue(objectMapper, "objectMapper");
        ObjectMapper objectMapper2 = objectMapper;
        TreeNode n$iv = statusReceived.getValue();
        boolean $i$f$treeToValue = false;
        boolean $i$f$jacksonTypeRef = false;
        DeviceStatusUpdate commandUpdateStatus = (DeviceStatusUpdate)$this$treeToValue$iv.readValue($this$treeToValue$iv.treeAsTokens(n$iv), (TypeReference)new TypeReference<DeviceStatusUpdate>(){});
        this.getLogger().info("Received firmware upgrade status from device " + statusReceived.getDeviceID() + " : " + commandUpdateStatus);
        CommandInfo commandInfo = this.commandIdMap.get(statusReceived.getDeviceID());
        if (commandInfo == null) {
            this.getLogger().info("No command in progress for device " + statusReceived.getDeviceID() + ", skipping");
            return;
        }
        long currentTime = System.currentTimeMillis();
        long fiveMinutesInMillis = 300000L;
        if (Intrinsics.areEqual(commandInfo.getLastStatus(), commandUpdateStatus.getStatus())) {
            long timeSinceLastSent = currentTime - commandInfo.getLastStatusSentTime();
            if (timeSinceLastSent < fiveMinutesInMillis) {
                this.getLogger().info("Status " + commandUpdateStatus.getStatus() + " already sent for device " + statusReceived.getDeviceID() + " " + timeSinceLastSent / (long)1000 + " seconds ago, skipping (waiting for 5 minutes)");
                return;
            }
            this.getLogger().info("Status " + commandUpdateStatus.getStatus() + " already sent for device " + statusReceived.getDeviceID() + ", but 5 minutes have passed, sending again");
        }
        int n = commandUpdateStatus.getCode();
        String string = commandInfo.getCommandId();
        String string2 = commandUpdateStatus.getMessage();
        String string3 = commandUpdateStatus.getStatus();
        DeviceCommandResponse response2 = new DeviceCommandResponse(n, string2, "", string, string3, null, 32, null);
        UpdateStatusTelemetry updateStatusTelemetry = new UpdateStatusTelemetry(response2);
        this.sendUpdateStatusTelemetry(updateStatusTelemetry, statusReceived.getDeviceID());
        commandInfo.setLastStatus(commandUpdateStatus.getStatus());
        commandInfo.setLastStatusSentTime(currentTime);
        if (commandUpdateStatus.getCode() == 200 || commandUpdateStatus.getCode() == 500) {
            this.commandIdMap.remove(statusReceived.getDeviceID());
        }
    }

    private final void sendUpdateStatusTelemetry(UpdateStatusTelemetry updateStatusTelemetry, String deviceId) {
        DeviceEdgeMessage deviceEdgeMessage = this.lastDeviceDiagnosticSent.get(deviceId);
        DeviceEdgeMessage deviceEdgeMessage2 = this.lastDeviceDiagnosticSent.get(deviceId);
        DeviceEdgeMessage edgeMessage = new DeviceEdgeMessage(null, updateStatusTelemetry, String.valueOf(deviceEdgeMessage != null ? deviceEdgeMessage.getDeviceModel() : null), String.valueOf(deviceEdgeMessage2 != null ? deviceEdgeMessage2.getParentPath() : null), DataType.JSON, 1, null);
        String string = "device/" + deviceId + "/diagnostic";
        String string2 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
        Intrinsics.checkNotNullExpressionValue(string2, "objectMapper.writeValueAsString(edgeMessage)");
        IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, string, string2, 0, 4, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleDeviceConnectionStatus(StatusEvent<JsonNode> var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof handleDeviceConnectionStatus.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$handleDeviceConnectionStatus(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                v0 = ConstKt.getObjectMapper();
                Intrinsics.checkNotNullExpressionValue(v0, "objectMapper");
                var4_6 = v0;
                from$iv = statusReceived.getValue();
                $i$f$convertValue = false;
                $i$f$jacksonTypeRef = false;
                deviceConnectionStatus = (DeviceConnectionStatus)$this$convertValue$iv.convertValue(from$iv, new TypeReference<DeviceConnectionStatus>(){});
                if (this.lastDeviceDiagnosticSent.containsKey(deviceConnectionStatus.getId())) {
                    v1 = this.lastDeviceDiagnosticSent.get(deviceConnectionStatus.getId());
                    deviceConnectionStatus.setDeviceModel(String.valueOf(v1 != null ? v1.getDeviceModel() : null));
                    v2 = this.lastDeviceDiagnosticSent.get(deviceConnectionStatus.getId());
                    deviceConnectionStatus.setParentPath(String.valueOf(v2 != null ? v2.getParentPath() : null));
                }
                if (!deviceConnectionStatus.getConnected()) break;
                this.subscribeToDeviceCommands(statusReceived.getDeviceID());
                $continuation.L$0 = this;
                $continuation.label = 1;
                v3 = this.client.getDevice(statusReceived.getDeviceID(), $continuation);
                if (v3 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl36:
                // 2 sources

                device = (Device)((BaseResponse)v3).getContent();
                $continuation.L$0 = null;
                $continuation.label = 2;
                v4 = this.sendDeviceDiagnosticToMqtt(device, null, true, $continuation);
                if (v4 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl46
            }
            case 2: {
                ResultKt.throwOnFailure($result);
                v4 = $result;
lbl46:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        this.mqtt.unsubscribeToDeviceCommands(statusReceived.getDeviceID());
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void sendUpdateStatusConnection(String deviceID, ConnectionStatus connectionStatus) {
        String string = "device/" + deviceID + "/connection";
        String string2 = ConstKt.getObjectMapper().writeValueAsString(connectionStatus);
        Intrinsics.checkNotNullExpressionValue(string2, "objectMapper.writeValueAsString(connectionStatus)");
        IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, string, string2, 0, 4, null);
    }

    private final void scheduleSendTelemetryTask() {
        Timer timer = new Timer();
        long l = this.config.getAgent().getSendTelemetryMs();
        long l2 = this.config.getAgent().getSendTelemetryMs();
        TimerTask timerTask2 = new TimerTask(this){
            final /* synthetic */ GatewayCommManager this$0;
            {
                this.this$0 = gatewayCommManager;
            }

            public void run() {
                TimerTask $this$scheduleSendTelemetryTask_u24lambda_u240 = this;
                boolean bl = false;
                BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ GatewayCommManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.label = 1;
                                Object object3 = GatewayCommManager.access$sendAllTelemetriesWithRetry(this.this$0, 10, this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                Object object3;
                                try {
                                    void $result;
                                    ResultKt.throwOnFailure($result);
                                    object3 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (Exception e) {
                                    this.this$0.getLogger().error("Telemetry send task failed", (Throwable)e);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
            }
        };
        timer.scheduleAtFixedRate(timerTask2, l, l2);
    }

    private final void subscribeToHostCommands() {
        try {
            this.getLogger().info("Subscribing to host commands");
            Host hostinfo2 = (Host)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Host>, Object>(this, null){
                int label;
                final /* synthetic */ GatewayCommManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = GatewayCommManager.access$getClient$p(this.this$0).getHostInfo(this);
                            if (object3 != object2) return ((BaseResponse)object3).getContent();
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return ((BaseResponse)object3).getContent();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Host> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            this.subscribeToDeviceCommands(String.valueOf(hostinfo2.getHostname()));
        }
        catch (ConnectException e) {
            this.getLogger().error("Command Subscription failed. Subscription will be handled on next telemetry send");
        }
    }

    private final void subscribeToDeviceCommands() {
        try {
            this.getLogger().info("Subscribing to device commands");
            List deviceList2 = (List)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super List<? extends Device>>, Object>(this, null){
                int label;
                final /* synthetic */ GatewayCommManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = GatewayCommManager.access$getClient$p(this.this$0).listDevices(this);
                            if (object3 != object2) return ((BaseResponse)object3).getContent();
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return ((BaseResponse)object3).getContent();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<Device>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            List<String> deviceListIds = Utils.INSTANCE.getDeviceListIds(deviceList2);
            Iterable $this$forEach$iv = deviceListIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String id = (String)element$iv;
                boolean bl = false;
                this.subscribeToDeviceCommands(id);
            }
        }
        catch (ConnectException e) {
            this.getLogger().error("Command Subscription failed. Subscription will be handled on next telemetry send");
        }
    }

    private final void subscribeToDeviceCommands(String deviceId) {
        this.mqtt.subscribeToDeviceCommands(deviceId, (Function2<? super String, ? super byte[], Unit>)new Function2<String, byte[], Unit>(this){
            final /* synthetic */ GatewayCommManager this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String topic, @NotNull byte[] message) {
                Intrinsics.checkNotNullParameter(topic, "topic");
                Intrinsics.checkNotNullParameter(message, "message");
                GatewayCommManager.access$handleCommandRequest(this.this$0, topic, message);
            }
        });
    }

    private final void subscribeToDeviceCommands(List<Device> deviceList2) {
        this.getLogger().debug("Checking for device connection or disconnection");
        List deviceIdList = CollectionsKt.toMutableList((Collection)Utils.INSTANCE.getDeviceListIds(deviceList2));
        ((Collection)deviceIdList).add(this.hostname);
        Set<String> deviceIdCommandsSubscribed = this.mqtt.getDeviceIdCommandsSubscribed();
        Iterable $this$forEach$iv = deviceIdCommandsSubscribed;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.getLogger().info("Currently subscribed to device commands for device " + it);
        }
        if (!Intrinsics.areEqual(CollectionsKt.toSet(deviceIdList), CollectionsKt.toSet((Iterable)deviceIdCommandsSubscribed))) {
            String deviceId;
            this.getLogger().info("Found a discrepancy between device connected on DIS and mqtt command subscription");
            List newDevices = CollectionsKt.minus((Iterable)deviceIdList, (Iterable)deviceIdCommandsSubscribed);
            Set<String> removedDevices = SetsKt.minus(deviceIdCommandsSubscribed, deviceIdList);
            Iterable $this$forEach$iv2 = newDevices;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                deviceId = (String)element$iv;
                boolean bl = false;
                this.getLogger().info("New device detected " + deviceId);
                this.subscribeToDeviceCommands(deviceId);
            }
            $this$forEach$iv2 = removedDevices;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                deviceId = (String)element$iv;
                boolean bl = false;
                this.getLogger().info("Device removed " + deviceId);
                this.mqtt.unsubscribeToDeviceCommands(deviceId);
            }
        } else {
            this.getLogger().debug("No discrepancy between device connected on DIS and mqtt command subscription");
        }
    }

    private final void handleCommandRequest(String topic, byte[] message) {
        this.getLogger().info("Received command from topic " + topic);
        ObjectMapper objectMapper = ConstKt.getObjectMapper();
        Intrinsics.checkNotNullExpressionValue(objectMapper, "objectMapper");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        DeviceCommandMqtt deviceCommand = (DeviceCommandMqtt)$this$readValue$iv.readValue(message, (TypeReference)new TypeReference<DeviceCommandMqtt>(){});
        String deviceId = Utils.INSTANCE.getDeviceFromTopic(topic);
        String commandName = Utils.INSTANCE.getCommandFromTopic(topic);
        if (deviceCommand.getAttachments() != null && !((Collection)deviceCommand.getAttachments()).isEmpty()) {
            this.getLogger().info("Command contains " + deviceCommand.getAttachments().size() + " attachments");
            Iterable $this$forEach$iv = deviceCommand.getAttachments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Attachment attachment = (Attachment)element$iv;
                boolean bl = false;
                this.getLogger().debug("Attachment: " + attachment.getFilePath());
            }
        }
        KotlinLogger kotlinLogger = this.getLogger();
        Object object = deviceCommand.getPayload();
        if (object == null) {
            object = "";
        }
        kotlinLogger.info("Received command " + commandName + " on device " + deviceId + " with payload " + object);
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(commandName, this, deviceId, deviceCommand, null){
            int label;
            final /* synthetic */ String $commandName;
            final /* synthetic */ GatewayCommManager this$0;
            final /* synthetic */ String $deviceId;
            final /* synthetic */ DeviceCommandMqtt $deviceCommand;
            {
                this.$commandName = $commandName;
                this.this$0 = $receiver;
                this.$deviceId = $deviceId;
                this.$deviceCommand = $deviceCommand;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CASE], 7[SWITCH]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void handleException(Throwable e, DeviceCommandMqtt deviceCommand) {
        this.getLogger().error("Exception " + e, e);
        String string = deviceCommand.getResponseTopic();
        if (string == null) {
            return;
        }
        String responseTopic = string;
        Pair<String, CommandStatusCode> pair = e instanceof SdsNotFoundException ? TuplesKt.to("Device not found", CommandStatusCode.SDS_DEVICE_NOT_FOUND) : TuplesKt.to("Command failed", CommandStatusCode.SDS_INTERNAL_ERROR);
        String message = pair.component1();
        CommandStatusCode statusCode = pair.component2();
        IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, responseTopic, Utils.INSTANCE.buildCommandResponseAsString(500, message, "", deviceCommand.getCommandId(), statusCode), 0, 4, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleGetConfigCommand(String var1_1, DeviceCommandMqtt var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof handleGetConfigCommand.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$handleGetConfigCommand(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.getLogger().info("Get configuration from device " + (String)deviceId);
                $continuation.L$0 = this;
                $continuation.L$1 = deviceCommand;
                $continuation.label = 1;
                v0 = this.client.getConfig((String)deviceId, $continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl25:
                // 2 sources

                res = (DeviceCommandResponse)v0;
                body = DeviceCommandResponse.copy$default(res, 0, null, null, deviceCommand.getCommandId(), null, null, 55, null);
                this.getLogger().info("Received response " + body);
                message = ConstKt.getObjectMapper().writeValueAsString(body);
                if (deviceCommand.getResponseTopic() != null) {
                    v1 = deviceCommand.getResponseTopic();
                    Intrinsics.checkNotNullExpressionValue(message, "message");
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v1, message, 0, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleSetConfigCommand(String var1_1, DeviceCommandMqtt var2_2, Continuation<? super Unit> var3_3) {
        block13: {
            if (!(var3_3 instanceof handleSetConfigCommand.1)) ** GOTO lbl-1000
            var11_4 = var3_3;
            if ((var11_4.label & -2147483648) != 0) {
                var11_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ GatewayCommManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return GatewayCommManager.access$handleSetConfigCommand(this.this$0, null, null, this);
                    }
                };
            }
            $result = $continuation.result;
            var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    this.getLogger().info("Set configuration from device " + deviceId);
                    var4_7 = deviceCommand.getAttachments();
                    if (var4_7 == null || var4_7.isEmpty() != false) break;
                    firmwareConfig = ConfigHelper.INSTANCE.getConfig().getFiles();
                    edgeConfig = ConfigHelper.INSTANCE.getConfig().getEdge();
                    storageModuleClient = new StorageModuleClient(firmwareConfig.getProtocol(), edgeConfig.getHost(), firmwareConfig.getPort());
                    this.sendCommandProgress(deviceCommand, "Downloading package on agent: 0%", CommandStatusCode.SDS_PACKAGE_DOWNLOADING);
                    $continuation.L$0 = this;
                    $continuation.L$1 = deviceId;
                    $continuation.L$2 = deviceCommand;
                    $continuation.label = 1;
                    v0 = storageModuleClient.downloadFile(CollectionsKt.first(deviceCommand.getAttachments()).getFilePath(), (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(this, deviceCommand){
                        final /* synthetic */ GatewayCommManager this$0;
                        final /* synthetic */ DeviceCommandMqtt $deviceCommand;
                        {
                            this.this$0 = $receiver;
                            this.$deviceCommand = $deviceCommand;
                            super(1);
                        }

                        public final void invoke(int progress) {
                            GatewayCommManager.access$sendCommandProgress(this.this$0, this.$deviceCommand, "Downloading package on agent: " + progress + "%", CommandStatusCode.SDS_PACKAGE_DOWNLOADING);
                        }
                    }, $continuation);
                    if (v0 == var12_6) {
                        return var12_6;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    deviceCommand = (DeviceCommandMqtt)$continuation.L$2;
                    deviceId = (String)$continuation.L$1;
                    this = (GatewayCommManager)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    configUri = (String)v0;
                    this.sendCommandProgress(deviceCommand, "Package downloaded", CommandStatusCode.SDS_PACKAGE_DOWNLOADED);
                    this.getLogger().info("Payload " + deviceCommand.getPayload());
                    this.commandIdMap.put(deviceId, new CommandInfo(deviceCommand.getCommandId(), null, 0L, 6, null));
                    this.getLogger().info("Setting config from file " + configUri + " on device " + deviceId);
                    $continuation.L$0 = this;
                    $continuation.L$1 = deviceCommand;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    v1 = this.client.setConfig(deviceId, configUri, $continuation);
                    ** if (v1 != var12_6) goto lbl48
lbl47:
                    // 1 sources

                    return var12_6;
lbl48:
                    // 1 sources

                    ** GOTO lbl56
                }
                case 2: {
                    deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                    this = (GatewayCommManager)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl56:
                        // 2 sources

                        res = (DeviceCommandResponse)v1;
                        body = DeviceCommandResponse.copy$default(res, 0, null, null, deviceCommand.getCommandId(), null, null, 55, null);
                        this.getLogger().info("Received response " + body);
                    }
                    catch (ClientRequestException e) {
                        this.getLogger().error("Set config failed", (Throwable)e);
                        Utils.INSTANCE.buildCommandResponseAsString(500, "Set config failed", "", deviceCommand.getCommandId(), CommandStatusCode.SDS_INVALID_REQUEST);
                    }
                    catch (ServerResponseException e) {
                        this.getLogger().error("Set config failed", (Throwable)e);
                        Utils.INSTANCE.buildCommandResponseAsString(500, "Set config failed", "", deviceCommand.getCommandId(), CommandStatusCode.SDS_INVALID_REQUEST);
                    }
                    break block13;
                }
            }
            Utils.INSTANCE.buildCommandResponseAsString(500, "Set config failed: body was empty", "", deviceCommand.getCommandId(), CommandStatusCode.SDS_INVALID_REQUEST);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void sendCommandProgress(DeviceCommandMqtt deviceCommand, String message, CommandStatusCode commandStatusCode) {
        String commandMessage = Utils.INSTANCE.buildCommandResponseAsString(202, message, "", deviceCommand.getCommandId(), commandStatusCode);
        if (deviceCommand.getResponseTopic() != null) {
            IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, deviceCommand.getResponseTopic(), commandMessage, 0, 4, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleGenericCommand(String var1_1, String var2_2, DeviceCommandMqtt var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof handleGenericCommand.1)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$handleGenericCommand(this.this$0, null, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                v0 = this.getLogger();
                v1 = deviceCommand.getPayload();
                if (v1 == null) {
                    v1 = "";
                }
                v0.info("Sending command " + (String)commandName + " on device " + (String)deviceId + " with payload " + v1);
                $continuation.L$0 = this;
                $continuation.L$1 = deviceCommand;
                $continuation.label = 1;
                v2 = this.client.sendCommand((String)deviceId, (String)commandName, deviceCommand.getPayload(), $continuation);
                if (v2 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl29
            }
            case 1: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl29:
                // 2 sources

                res = (DeviceCommandResponse)v2;
                body = DeviceCommandResponse.copy$default(res, 0, null, null, deviceCommand.getCommandId(), null, null, 55, null);
                this.getLogger().info("Received response " + body);
                if (deviceCommand.getResponseTopic() != null) {
                    v3 = deviceCommand.getResponseTopic();
                    var7_10 = ConstKt.getObjectMapper().writeValueAsString(body);
                    Intrinsics.checkNotNullExpressionValue(var7_10, "objectMapper.writeValueAsString(body)");
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v3, var7_10, 0, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleRefreshConfigDiagnosticCommand(String var1_1, DeviceCommandMqtt var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof handleRefreshConfigDiagnosticCommand.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$handleRefreshConfigDiagnosticCommand(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (!Intrinsics.areEqual(deviceId, this.hostname)) break;
                $continuation.L$0 = this;
                $continuation.L$1 = deviceCommand;
                $continuation.label = 1;
                v0 = this.sendHostDiagnosticToMqtt(false, $continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl54
            }
            case 1: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl54
            }
        }
        var4_7 = this;
        $continuation.L$0 = this;
        $continuation.L$1 = deviceCommand;
        $continuation.L$2 = var4_7;
        $continuation.label = 2;
        v1 = this.client.getDevice((String)deviceId, $continuation);
        if (v1 == var7_6) {
            return var7_6;
        }
        ** GOTO lbl41
        {
            case 2: {
                var4_7 = (GatewayCommManager)$continuation.L$2;
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl41:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = deviceCommand;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v2 = var4_7.sendDeviceDiagnosticToMqtt((Device)((BaseResponse)v1).getContent(), null, false, $continuation);
                if (v2 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl54
            }
            case 3: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl54:
                // 4 sources

                if (deviceCommand.getResponseTopic() != null) {
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, deviceCommand.getResponseTopic(), Utils.INSTANCE.buildCommandResponseAsString(200, "GetDiagnostic success", "", deviceCommand.getCommandId(), CommandStatusCode.SUCCESS), 0, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleRefreshConfigTelemetriesCommand(String var1_1, DeviceCommandMqtt var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof handleRefreshConfigTelemetriesCommand.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$handleRefreshConfigTelemetriesCommand(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (!Intrinsics.areEqual(deviceId, this.hostname)) break;
                $continuation.L$0 = this;
                $continuation.L$1 = deviceCommand;
                $continuation.label = 1;
                v0 = this.sendHostTelemetriesToMqtt($continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl54
            }
            case 1: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl54
            }
        }
        var4_7 = this;
        $continuation.L$0 = this;
        $continuation.L$1 = deviceCommand;
        $continuation.L$2 = var4_7;
        $continuation.label = 2;
        v1 = this.client.getDevice((String)deviceId, $continuation);
        if (v1 == var7_6) {
            return var7_6;
        }
        ** GOTO lbl41
        {
            case 2: {
                var4_7 = (GatewayCommManager)$continuation.L$2;
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl41:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = deviceCommand;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v2 = var4_7.sendDeviceTelemetriesToMqtt((Device)((BaseResponse)v1).getContent(), null, $continuation);
                if (v2 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl54
            }
            case 3: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl54:
                // 4 sources

                if (deviceCommand.getResponseTopic() != null) {
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, deviceCommand.getResponseTopic(), Utils.INSTANCE.buildCommandResponseAsString(200, "GetProperties success", "", deviceCommand.getCommandId(), CommandStatusCode.SUCCESS), 0, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleRefreshConfigPropertiesCommand(String var1_1, DeviceCommandMqtt var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof handleRefreshConfigPropertiesCommand.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$handleRefreshConfigPropertiesCommand(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (!Intrinsics.areEqual(deviceId, this.hostname)) break;
                $continuation.L$0 = this;
                $continuation.L$1 = deviceCommand;
                $continuation.label = 1;
                v0 = this.sendHostPropertiesToMqtt($continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl38
            }
            case 1: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl38
            }
        }
        $continuation.L$0 = this;
        $continuation.L$1 = deviceCommand;
        $continuation.label = 2;
        v1 = this.sendDevicePropertiesToMqtt((String)deviceId, $continuation);
        if (v1 == var6_6) {
            return var6_6;
        }
        ** GOTO lbl38
        {
            case 2: {
                deviceCommand = (DeviceCommandMqtt)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl38:
                // 4 sources

                if (deviceCommand.getResponseTopic() != null) {
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, deviceCommand.getResponseTopic(), Utils.INSTANCE.buildCommandResponseAsString(200, "GetProperties success", "", deviceCommand.getCommandId(), CommandStatusCode.SUCCESS), 0, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @WithSpan
    private final Object sendHostTelemetriesToMqtt(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof sendHostTelemetriesToMqtt.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendHostTelemetriesToMqtt(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.getLogger().info("Sending host telemetries to mqtt");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.client.getHostInfo($continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl23:
                // 2 sources

                hostInfo = (Host)((BaseResponse)v0).getContent();
                this.getLogger().debug("Host info received\n" + hostInfo);
                telemetry = new Host(null, null, null, null, null, hostInfo.getCpuLoad(), null, hostInfo.getJvmFreeMemoryMB(), null, null, hostInfo.getPhysicalMemoryFreeMB(), hostInfo.getDiskInfo(), null, 4959, null);
                edgeMessage = new HostEdgeMessage(telemetry, null, this.hostname, 2, null);
                this.getLogger().info("Sending for host " + hostInfo.getHostname() + " telemetries " + edgeMessage);
                v1 = "device/" + hostInfo.getHostname() + "/diagnostic";
                v2 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                Intrinsics.checkNotNullExpressionValue(v2, "objectMapper.writeValueAsString(edgeMessage)");
                IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v1, v2, 0, 4, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @WithSpan
    private final Object sendDeviceTelemetriesToMqtt(Device var1_1, String var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof sendDeviceTelemetriesToMqtt.1)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendDeviceTelemetriesToMqtt(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                deviceId = device.getId();
                this.getLogger().info("Get telemetry for device " + deviceId);
                $continuation.L$0 = this;
                $continuation.L$1 = device;
                $continuation.L$2 = parentPath;
                $continuation.L$3 = deviceId;
                $continuation.label = 1;
                v0 = this.client.getHealth(deviceId, $continuation);
                if (v0 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                deviceId = (String)$continuation.L$3;
                parentPath = (String)$continuation.L$2;
                device = (Device)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl30:
                // 2 sources

                deviceHealth = (String)((BaseResponse)v0).getContent();
                $continuation.L$0 = this;
                $continuation.L$1 = device;
                $continuation.L$2 = parentPath;
                $continuation.L$3 = deviceHealth;
                $continuation.label = 2;
                v1 = this.client.getStats(deviceId, $continuation);
                if (v1 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl47
            }
            case 2: {
                deviceHealth = (String)$continuation.L$3;
                parentPath = (String)$continuation.L$2;
                device = (Device)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl47:
                // 2 sources

                deviceStats = (String)((BaseResponse)v1).getContent();
                deviceTelemetry = deviceHealth + deviceStats;
                this.getLogger().debug("Telemetry received\n" + deviceTelemetry);
                v2 = new StatsHealthTelemetry(deviceStats, deviceHealth);
                v3 = device.getModel();
                v4 = parentPath;
                v5 = v4 != null ? ((CharSequence)v4).length() > 0 : false;
                if (v5) {
                    v6 = parentPath.substring(0, parentPath.length() - 1);
                    v7 = v6;
                    Intrinsics.checkNotNullExpressionValue(v6, "substring(...)");
                } else {
                    v7 = this.hostname;
                }
                edgeMessage = new DeviceEdgeMessage(v2, null, v3, v7, null, 18, null);
                this.getLogger().info("Sending telemetry for device " + device.getId() + " telemetry " + edgeMessage);
                v8 = "device/" + device.getId() + "/diagnostic";
                var9_12 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                Intrinsics.checkNotNullExpressionValue(var9_12, "objectMapper.writeValueAsString(edgeMessage)");
                IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v8, var9_12, 0, 4, null);
                if (!(((Collection)device.getChildren()).isEmpty() == false)) break;
                v9 = parentPath;
                if (v9 == null) {
                    v9 = this.hostname + "/";
                }
                pP = v9;
                pP = (String)pP + device.getId() + "/";
                var10_13 = device.getChildren().iterator();
lbl73:
                // 3 sources

                while (var10_13.hasNext()) {
                    child = (Device)var10_13.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = pP;
                    $continuation.L$2 = var10_13;
                    $continuation.L$3 = null;
                    $continuation.label = 3;
                    v10 = this.sendDeviceDiagnosticToMqtt(child, (String)pP, true, $continuation);
                    if (v10 != var14_6) continue;
                    return var14_6;
                }
                break;
            }
            case 3: {
                var10_13 = (Iterator<Device>)$continuation.L$2;
                pP = (String)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v10 = $result;
                ** GOTO lbl73
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @WithSpan
    private final Object sendHostPropertiesToMqtt(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof sendHostPropertiesToMqtt.1)) ** GOTO lbl-1000
        var13_2 = var1_1;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendHostPropertiesToMqtt(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.getLogger().info("Sending host properties to mqtt");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.client.getHostInfo($continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl23:
                // 2 sources

                hostInfo = (Host)((BaseResponse)v0).getContent();
                this.getLogger().debug("Host info received\n" + hostInfo);
                var4_6 = hostInfo.getHostname();
                var5_7 = hostInfo.getOsName();
                var6_8 = hostInfo.getOsVersion();
                var7_9 = hostInfo.getOsArch();
                var8_10 = hostInfo.getCpuCores();
                var9_11 = hostInfo.getPhysicalMemoryTotalMB();
                var10_12 = hostInfo.getNetworkInterfaces();
                var11_13 = hostInfo.getJvmMaxMemoryMB();
                prop = new Host(var4_6, var5_7, var6_8, var7_9, var8_10, null, null, null, var11_13, var9_11, null, null, var10_12, 3296, null);
                edgeMessage = new HostEdgeMessage(null, prop, this.hostname, 1, null);
                this.getLogger().info("Sending for host " + hostInfo.getHostname() + " properties " + edgeMessage);
                v1 = "device/" + hostInfo.getHostname() + "/diagnostic";
                v2 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                Intrinsics.checkNotNullExpressionValue(v2, "objectMapper.writeValueAsString(edgeMessage)");
                IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v1, v2, 0, 4, null);
                this.lastHostPropSent = prop;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendDevicePropertiesToMqtt(String var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof sendDevicePropertiesToMqtt.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendDevicePropertiesToMqtt(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.client.getDevice((String)deviceId, $continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                device = (Device)((BaseResponse)v0).getContent();
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.sendDevicePropertiesToMqtt(device, null, $continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl32
            }
            case 2: {
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl32:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @WithSpan
    private final Object sendDevicePropertiesToMqtt(Device var1_1, String var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof sendDevicePropertiesToMqtt.2)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendDevicePropertiesToMqtt(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                deviceId = device.getId();
                this.getLogger().info("Get properties for device " + deviceId);
                $continuation.L$0 = this;
                $continuation.L$1 = device;
                $continuation.L$2 = parentPath;
                $continuation.L$3 = deviceId;
                $continuation.label = 1;
                v0 = this.client.getInfo(deviceId, $continuation);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                deviceId = (String)$continuation.L$3;
                parentPath = (String)$continuation.L$2;
                device = (Device)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl30:
                // 2 sources

                deviceProperties = (String)((BaseResponse)v0).getContent();
                v1 = new InfoTelemetry(deviceProperties);
                v2 = device.getModel();
                v3 = parentPath;
                v4 = v3 != null ? ((CharSequence)v3).length() > 0 : false;
                if (v4) {
                    v5 = parentPath.substring(0, parentPath.length() - 1);
                    v6 = v5;
                    Intrinsics.checkNotNullExpressionValue(v5, "substring(...)");
                } else {
                    v6 = this.hostname;
                }
                edgeMessage = new DeviceEdgeMessage(null, v1, v2, v6, null, 17, null);
                sendTelemetryTopic = "device/" + deviceId + "/diagnostic";
                v7 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                Intrinsics.checkNotNullExpressionValue(v7, "objectMapper.writeValueAsString(edgeMessage)");
                IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, sendTelemetryTopic, v7, 0, 4, null);
                if (!this.lastDeviceDiagnosticSent.containsKey(device.getId())) {
                    this.lastDeviceDiagnosticSent.put(device.getId(), edgeMessage);
                } else {
                    em = this.lastDeviceDiagnosticSent.get(device.getId());
                    if (em != null) {
                        em.setProperty(edgeMessage.getProperty());
                    }
                }
                if (!(((Collection)device.getChildren()).isEmpty() == false)) break;
                v8 = parentPath;
                if (v8 == null) {
                    v8 = this.hostname + "/";
                }
                pP = v8;
                pP = (String)pP + device.getId() + "/";
                var9_12 = device.getChildren().iterator();
lbl60:
                // 3 sources

                while (var9_12.hasNext()) {
                    child = (Device)var9_12.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = pP;
                    $continuation.L$2 = var9_12;
                    $continuation.L$3 = null;
                    $continuation.label = 2;
                    v9 = this.sendDevicePropertiesToMqtt(child, (String)pP, $continuation);
                    if (v9 != var13_6) continue;
                    return var13_6;
                }
                break;
            }
            case 2: {
                var9_12 = (Iterator<Device>)$continuation.L$2;
                pP = (String)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v9 = $result;
                ** GOTO lbl60
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @WithSpan
    private final Object sendAllDiagnosticsToMqtt(Continuation<? super Boolean> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @WithSpan
    private final Object sendHostDiagnosticToMqtt(boolean var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof sendHostDiagnosticToMqtt.1)) ** GOTO lbl-1000
        var15_3 = var2_2;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendHostDiagnosticToMqtt(this.this$0, false, this);
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.getLogger().info("Sending host diagnostic to mqtt");
                $continuation.L$0 = this;
                $continuation.Z$0 = discardAlreadySentProperties;
                $continuation.label = 1;
                v0 = this.client.getHostInfo($continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                discardAlreadySentProperties = $continuation.Z$0;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl25:
                // 2 sources

                hostInfo = (Host)((BaseResponse)v0).getContent();
                this.getLogger().debug("Host diagnostic received\n" + hostInfo);
                this.hostname = String.valueOf(hostInfo.getHostname());
                if (!this.sentHostConnected) {
                    this.sendUpdateStatusConnection(String.valueOf(hostInfo.getHostname()), new HostConnectionStatus(String.valueOf(hostInfo.getHostname()), true));
                    this.sentHostConnected = true;
                }
                telemetry = new Host(null, null, null, null, null, hostInfo.getCpuLoad(), null, hostInfo.getJvmFreeMemoryMB(), null, null, hostInfo.getPhysicalMemoryFreeMB(), hostInfo.getDiskInfo(), null, 4959, null);
                var6_8 = hostInfo.getHostname();
                var7_9 = hostInfo.getOsName();
                var8_11 = hostInfo.getOsVersion();
                var9_12 = hostInfo.getOsArch();
                var10_13 = hostInfo.getCpuCores();
                var11_14 = hostInfo.getPhysicalMemoryTotalMB();
                var12_15 = hostInfo.getNetworkInterfaces();
                var13_16 = hostInfo.getJvmMaxMemoryMB();
                prop = new Host(var6_8, var7_9, var8_11, var9_12, var10_13, null, null, null, var13_16, var11_14, null, null, var12_15, 3296, null);
                edgeMessage = new HostEdgeMessage(telemetry, prop, this.hostname);
                toUpdate = false;
                if (!discardAlreadySentProperties) {
                    toUpdate = true;
                } else if (Intrinsics.areEqual(this.lastHostPropSent, edgeMessage.getProperty())) {
                    edgeMessage.setProperty(null);
                } else {
                    toUpdate = true;
                }
                this.getLogger().info("Sending for host " + hostInfo.getHostname() + " diagnostic " + edgeMessage);
                v1 = "device/" + hostInfo.getHostname() + "/diagnostic";
                v2 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                Intrinsics.checkNotNullExpressionValue(v2, "objectMapper.writeValueAsString(edgeMessage)");
                IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v1, v2, 0, 4, null);
                if (toUpdate) {
                    this.lastHostPropSent = edgeMessage.getProperty();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @WithSpan
    private final Object sendDeviceDiagnosticToMqtt(Device var1_1, String var2_2, boolean var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof sendDeviceDiagnosticToMqtt.1)) ** GOTO lbl-1000
        var15_5 = var4_4;
        if ((var15_5.label & -2147483648) != 0) {
            var15_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GatewayCommManager.access$sendDeviceDiagnosticToMqtt(this.this$0, null, null, false, this);
                }
            };
        }
        $result = $continuation.result;
        var16_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                deviceId = device.getId();
                this.getLogger().info("Get diagnostic for device " + deviceId);
                $continuation.L$0 = this;
                $continuation.L$1 = device;
                $continuation.L$2 = parentPath;
                $continuation.L$3 = deviceId;
                $continuation.Z$0 = discardAlreadySentProperties;
                $continuation.label = 1;
                v0 = this.client.getHealth(deviceId, $continuation);
                if (v0 == var16_7) {
                    return var16_7;
                }
                ** GOTO lbl32
            }
            case 1: {
                discardAlreadySentProperties = $continuation.Z$0;
                deviceId = (String)$continuation.L$3;
                parentPath = (String)$continuation.L$2;
                device = (Device)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl32:
                // 2 sources

                deviceHealth = (String)((BaseResponse)v0).getContent();
                $continuation.L$0 = this;
                $continuation.L$1 = device;
                $continuation.L$2 = parentPath;
                $continuation.L$3 = deviceId;
                $continuation.L$4 = deviceHealth;
                $continuation.Z$0 = discardAlreadySentProperties;
                $continuation.label = 2;
                v1 = this.client.getStats(deviceId, $continuation);
                if (v1 == var16_7) {
                    return var16_7;
                }
                ** GOTO lbl53
            }
            case 2: {
                discardAlreadySentProperties = $continuation.Z$0;
                deviceHealth = (String)$continuation.L$4;
                deviceId = (String)$continuation.L$3;
                parentPath = (String)$continuation.L$2;
                device = (Device)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl53:
                // 2 sources

                deviceStats = (String)((BaseResponse)v1).getContent();
                deviceTelemetry = deviceHealth + deviceStats;
                this.getLogger().debug("Telemetry received\n" + deviceTelemetry);
                $continuation.L$0 = this;
                $continuation.L$1 = device;
                $continuation.L$2 = parentPath;
                $continuation.L$3 = deviceHealth;
                $continuation.L$4 = deviceStats;
                $continuation.Z$0 = discardAlreadySentProperties;
                $continuation.label = 3;
                v2 = this.client.getInfo(deviceId, $continuation);
                if (v2 == var16_7) {
                    return var16_7;
                }
                ** GOTO lbl76
            }
            case 3: {
                discardAlreadySentProperties = $continuation.Z$0;
                deviceStats = (String)$continuation.L$4;
                deviceHealth = (String)$continuation.L$3;
                parentPath = (String)$continuation.L$2;
                device = (Device)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl76:
                // 2 sources

                deviceProperties = (String)((BaseResponse)v2).getContent();
                this.getLogger().debug("Properties received\n" + deviceProperties);
                v3 = new StatsHealthTelemetry(deviceStats, deviceHealth);
                v4 = new InfoTelemetry(deviceProperties);
                v5 = device.getModel();
                v6 = parentPath;
                v7 = v6 != null ? ((CharSequence)v6).length() > 0 : false;
                if (v7) {
                    v8 = parentPath.substring(0, parentPath.length() - 1);
                    v9 = v8;
                    Intrinsics.checkNotNullExpressionValue(v8, "substring(...)");
                } else {
                    v9 = this.hostname;
                }
                edgeMessage = new DeviceEdgeMessage(v3, v4, v5, v9, null, 16, null);
                if (!discardAlreadySentProperties) {
                    this.getLogger().info("Sending for device " + device.getId() + " diagnostic " + edgeMessage);
                    v10 = "device/" + device.getId() + "/diagnostic";
                    v11 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                    Intrinsics.checkNotNullExpressionValue(v11, "objectMapper.writeValueAsString(edgeMessage)");
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v10, v11, 0, 4, null);
                    if (!this.lastDeviceDiagnosticSent.containsKey(device.getId())) {
                        this.lastDeviceDiagnosticSent.put(device.getId(), edgeMessage);
                    } else {
                        em = this.lastDeviceDiagnosticSent.get(device.getId());
                        if (em != null) {
                            em.setProperty(edgeMessage.getProperty());
                        }
                    }
                } else if (!this.lastDeviceDiagnosticSent.containsKey(device.getId())) {
                    this.getLogger().info("Sending for device " + device.getId() + " diagnostic " + edgeMessage);
                    v12 = "device/" + device.getId() + "/diagnostic";
                    v13 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                    Intrinsics.checkNotNullExpressionValue(v13, "objectMapper.writeValueAsString(edgeMessage)");
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v12, v13, 0, 4, null);
                    this.lastDeviceDiagnosticSent.put(device.getId(), edgeMessage);
                } else {
                    em = this.lastDeviceDiagnosticSent.get(device.getId());
                    toUpdate = false;
                    if (em != null) {
                        if (Intrinsics.areEqual(em.getProperty(), edgeMessage.getProperty())) {
                            edgeMessage.setProperty(null);
                        } else {
                            toUpdate = true;
                        }
                    }
                    this.getLogger().info("Sending for device " + device.getId() + " diagnostic " + edgeMessage);
                    v14 = "device/" + device.getId() + "/diagnostic";
                    v15 = ConstKt.getObjectMapper().writeValueAsString(edgeMessage);
                    Intrinsics.checkNotNullExpressionValue(v15, "objectMapper.writeValueAsString(edgeMessage)");
                    IMqttHelper.DefaultImpls.sendMessage$default(this.mqtt, v14, v15, 0, 4, null);
                    if (toUpdate && em != null) {
                        em.setProperty(edgeMessage.getProperty());
                    }
                }
                if (!(((Collection)device.getChildren()).isEmpty() == false)) break;
                v16 = parentPath;
                if (v16 == null) {
                    v16 = this.hostname + "/";
                }
                pP = v16;
                pP = (String)pP + device.getId() + "/";
                var12_16 = device.getChildren().iterator();
lbl134:
                // 3 sources

                while (var12_16.hasNext()) {
                    child = (Device)var12_16.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = pP;
                    $continuation.L$2 = var12_16;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.Z$0 = discardAlreadySentProperties;
                    $continuation.label = 4;
                    v17 = this.sendDeviceDiagnosticToMqtt(child, (String)pP, discardAlreadySentProperties != false, $continuation);
                    if (v17 != var16_7) continue;
                    return var16_7;
                }
                break;
            }
            case 4: {
                discardAlreadySentProperties = $continuation.Z$0;
                var12_16 = (Iterator<Device>)$continuation.L$2;
                pP = (String)$continuation.L$1;
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v17 = $result;
                ** GOTO lbl134
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object close(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof close.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GatewayCommManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.close(this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.client.listDevices($continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GatewayCommManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                deviceList = (List)((BaseResponse)v0).getContent();
                this.sendDisconnectionEventToAllDevices(deviceList);
                if (!Intrinsics.areEqual(this.hostname, "")) {
                    this.sendUpdateStatusConnection(this.hostname, new HostConnectionStatus(this.hostname, false));
                }
                this.mqtt.disconnect();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void sendDisconnectionEventToAllDevices(List<Device> deviceList2) {
        Iterable $this$forEach$iv = deviceList2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Device device = (Device)element$iv;
            boolean bl = false;
            DeviceEdgeMessage deviceEdgeMessage = this.lastDeviceDiagnosticSent.get(device.getId());
            this.sendUpdateStatusConnection(device.getId(), new DeviceConnectionStatus(device.getId(), false, device.getModel(), String.valueOf(deviceEdgeMessage != null ? deviceEdgeMessage.getParentPath() : null)));
            this.sendDisconnectionEventToAllDevices(device.getChildren());
        }
    }

    @Override
    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger(this);
    }

    public static final /* synthetic */ IMqttHelper access$getMqtt$p(GatewayCommManager $this) {
        return $this.mqtt;
    }

    public static final /* synthetic */ void access$handleFirmwareUpgradeStatus(GatewayCommManager $this, StatusEvent statusReceived) {
        $this.handleFirmwareUpgradeStatus(statusReceived);
    }

    public static final /* synthetic */ Object access$handleDeviceConnectionStatus(GatewayCommManager $this, StatusEvent statusReceived, Continuation $completion) {
        return $this.handleDeviceConnectionStatus(statusReceived, $completion);
    }

    public static final /* synthetic */ MiddlewareApiClient access$getClient$p(GatewayCommManager $this) {
        return $this.client;
    }

    public static final /* synthetic */ void access$handleCommandRequest(GatewayCommManager $this, String topic, byte[] message) {
        $this.handleCommandRequest(topic, message);
    }

    public static final /* synthetic */ Object access$handleRefreshConfigPropertiesCommand(GatewayCommManager $this, String deviceId, DeviceCommandMqtt deviceCommand, Continuation $completion) {
        return $this.handleRefreshConfigPropertiesCommand(deviceId, deviceCommand, $completion);
    }

    public static final /* synthetic */ Object access$handleGetConfigCommand(GatewayCommManager $this, String deviceId, DeviceCommandMqtt deviceCommand, Continuation $completion) {
        return $this.handleGetConfigCommand(deviceId, deviceCommand, $completion);
    }

    public static final /* synthetic */ Object access$handleSetConfigCommand(GatewayCommManager $this, String deviceId, DeviceCommandMqtt deviceCommand, Continuation $completion) {
        return $this.handleSetConfigCommand(deviceId, deviceCommand, $completion);
    }

    public static final /* synthetic */ Object access$handleRefreshConfigTelemetriesCommand(GatewayCommManager $this, String deviceId, DeviceCommandMqtt deviceCommand, Continuation $completion) {
        return $this.handleRefreshConfigTelemetriesCommand(deviceId, deviceCommand, $completion);
    }

    public static final /* synthetic */ Object access$handleRefreshConfigDiagnosticCommand(GatewayCommManager $this, String deviceId, DeviceCommandMqtt deviceCommand, Continuation $completion) {
        return $this.handleRefreshConfigDiagnosticCommand(deviceId, deviceCommand, $completion);
    }

    public static final /* synthetic */ Object access$handleGenericCommand(GatewayCommManager $this, String deviceId, String commandName, DeviceCommandMqtt deviceCommand, Continuation $completion) {
        return $this.handleGenericCommand(deviceId, commandName, deviceCommand, $completion);
    }

    public static final /* synthetic */ void access$handleException(GatewayCommManager $this, Throwable e, DeviceCommandMqtt deviceCommand) {
        $this.handleException(e, deviceCommand);
    }

    public static final /* synthetic */ void access$sendCommandProgress(GatewayCommManager $this, DeviceCommandMqtt deviceCommand, String message, CommandStatusCode commandStatusCode) {
        $this.sendCommandProgress(deviceCommand, message, commandStatusCode);
    }

    public static final /* synthetic */ Object access$sendHostTelemetriesToMqtt(GatewayCommManager $this, Continuation $completion) {
        return $this.sendHostTelemetriesToMqtt($completion);
    }

    public static final /* synthetic */ Object access$sendDeviceTelemetriesToMqtt(GatewayCommManager $this, Device device, String parentPath, Continuation $completion) {
        return $this.sendDeviceTelemetriesToMqtt(device, parentPath, $completion);
    }

    public static final /* synthetic */ Object access$sendHostPropertiesToMqtt(GatewayCommManager $this, Continuation $completion) {
        return $this.sendHostPropertiesToMqtt($completion);
    }

    public static final /* synthetic */ Object access$sendDevicePropertiesToMqtt(GatewayCommManager $this, String deviceId, Continuation $completion) {
        return $this.sendDevicePropertiesToMqtt(deviceId, $completion);
    }

    public static final /* synthetic */ Object access$sendDevicePropertiesToMqtt(GatewayCommManager $this, Device device, String parentPath, Continuation $completion) {
        return $this.sendDevicePropertiesToMqtt(device, parentPath, $completion);
    }

    public static final /* synthetic */ Object access$sendAllDiagnosticsToMqtt(GatewayCommManager $this, Continuation $completion) {
        return $this.sendAllDiagnosticsToMqtt($completion);
    }

    public static final /* synthetic */ Object access$sendHostDiagnosticToMqtt(GatewayCommManager $this, boolean discardAlreadySentProperties, Continuation $completion) {
        return $this.sendHostDiagnosticToMqtt(discardAlreadySentProperties, $completion);
    }

    public static final /* synthetic */ Object access$sendDeviceDiagnosticToMqtt(GatewayCommManager $this, Device device, String parentPath, boolean discardAlreadySentProperties, Continuation $completion) {
        return $this.sendDeviceDiagnosticToMqtt(device, parentPath, discardAlreadySentProperties, $completion);
    }
}

