/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.agent.config;

import com.datalogic.agent.config.Config;
import com.datalogic.agent.utils.FileUtilsKt;
import com.sksamuel.hoplite.ClasspathResourceLoader;
import com.sksamuel.hoplite.ConfigFailure;
import com.sksamuel.hoplite.ConfigLoaderBuilder;
import com.sksamuel.hoplite.ConfigLoaderBuilderExtensionsKt;
import com.sksamuel.hoplite.ConfigSource;
import com.sksamuel.hoplite.DecoderContext;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.decoder.Decoder;
import com.sksamuel.hoplite.decoder.NonNullableLeafDecoder;
import com.sksamuel.hoplite.fp.Validated;
import com.sksamuel.hoplite.fp.ValidatedKt;
import com.sksamuel.hoplite.preprocessor.RandomPreprocessor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/datalogic/agent/config/ConfigHelper;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "CONFIG_FILE_NAME", "", "config", "Lcom/datalogic/agent/config/Config;", "getConfig", "()Lcom/datalogic/agent/config/Config;", "dl-client-sdk"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\ncom/datalogic/agent/config/ConfigHelper\n+ 2 ConfigLoader.kt\ncom/sksamuel/hoplite/ConfigLoader\n*L\n1#1,89:1\n80#2,13:90\n126#2:103\n*S KotlinDebug\n*F\n+ 1 Config.kt\ncom/datalogic/agent/config/ConfigHelper\n*L\n88#1:90,13\n88#1:103\n*E\n"})
public final class ConfigHelper
implements Logging {
    @NotNull
    public static final ConfigHelper INSTANCE;
    @NotNull
    public static final String CONFIG_FILE_NAME = "config.toml";
    @NotNull
    private static final Config config;

    private ConfigHelper() {
    }

    @NotNull
    public final Config getConfig() {
        return config;
    }

    @Override
    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger(this);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void this_$iv;
        INSTANCE = new ConfigHelper();
        Object configFile = new File(CONFIG_FILE_NAME);
        if (!((File)configFile).exists()) {
            boolean writable = ((File)configFile).setWritable(true, false);
            if (!writable) {
                INSTANCE.getLogger().warn("Configuration file not writable without admin rights ");
            }
            FileUtilsKt.copyFileFromResource(CONFIG_FILE_NAME, (File)configFile);
            String string = ((File)configFile).getPath();
            Intrinsics.checkNotNullExpressionValue(string, "configFile.path");
            FileUtilsKt.setWritePermission(string);
        }
        if (!new File("./certs").exists()) {
            Files.createDirectory(Paths.get("./certs", new String[0]), new FileAttribute[0]);
        }
        configFile = ConfigLoaderBuilderExtensionsKt.addFileSource(ConfigLoaderBuilder.Companion.default(), CONFIG_FILE_NAME, true, true).addPreprocessor(RandomPreprocessor.INSTANCE).addDecoder((Decoder)new NonNullableLeafDecoder<Level>(){

            @NotNull
            public Validated<ConfigFailure, Level> safeLeafDecode(@NotNull Node node2, @NotNull KType type2, @NotNull DecoderContext context) {
                Object object;
                Intrinsics.checkNotNullParameter(node2, "node");
                Intrinsics.checkNotNullParameter(type2, "type");
                Intrinsics.checkNotNullParameter(context, "context");
                if (node2 instanceof StringNode) {
                    Level level = Level.getLevel(((StringNode)node2).getValue());
                    object = level;
                    if (object == null || (object = ValidatedKt.valid(object)) == null) {
                        object = ValidatedKt.invalid(new ConfigFailure.DecodeError(node2, type2));
                    }
                } else {
                    object = ValidatedKt.invalid(new ConfigFailure.DecodeError(node2, type2));
                }
                return object;
            }

            public boolean supports(@NotNull KType type2) {
                Intrinsics.checkNotNullParameter(type2, "type");
                return Intrinsics.areEqual(type2.getClassifier(), Reflection.getOrCreateKotlinClass(Level.class));
            }

            @NotNull
            public Validated<ConfigFailure, Level> decode(@NotNull Node node2, @NotNull KType type2, @NotNull DecoderContext context) {
                return NonNullableLeafDecoder.DefaultImpls.decode(this, node2, type2, context);
            }

            public int priority() {
                return NonNullableLeafDecoder.DefaultImpls.priority(this);
            }

            @NotNull
            public Validated<ConfigFailure, Level> safeDecode(@NotNull Node node2, @NotNull KType type2, @NotNull DecoderContext context) {
                return NonNullableLeafDecoder.DefaultImpls.safeDecode(this, node2, type2, context);
            }
        }).build();
        String[] resourceOrFiles$iv = new String[]{};
        boolean $i$f$loadConfigOrThrow = false;
        List<String> resourceOrFiles$iv$iv = ArraysKt.toList(resourceOrFiles$iv);
        ClasspathResourceLoader classpathResourceLoader$iv$iv = ClasspathResourceLoader.Companion.toClasspathResourceLoader(ConfigSource.Companion.class);
        boolean $i$f$loadConfigOrThrow2 = false;
        void this_$iv$iv$iv = this_$iv;
        boolean $i$f$loadConfig = false;
        config = (Config)this_$iv.returnOrThrow(this_$iv$iv$iv.loadConfig(Reflection.getOrCreateKotlinClass(Config.class), CollectionsKt.emptyList(), resourceOrFiles$iv$iv, classpathResourceLoader$iv$iv));
    }
}

