/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.agent.mqtt;

import com.datalogic.agent.mqtt.IMqttHelper;
import com.datalogic.agent.utils.OpenTelemetryUtils;
import com.datalogic.agent.utils.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.eclipse.paho.mqttv5.client.IMqttMessageListener;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002Be\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\rH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0016J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J \u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0016J*\u0010%\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00042\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0013H\u0016J*\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00042\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0013H\u0016J\u0010\u0010)\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0004H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0011\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/datalogic/agent/mqtt/PahoHelper;", "Lorg/apache/logging/log4j/kotlin/Logging;", "Lcom/datalogic/agent/mqtt/IMqttHelper;", "clientId", "", "mqttHost", "mqttUsername", "mqttPassword", "caFilePath", "clientCrtFilePath", "clientKeyFilePath", "onConnectionSuccess", "Lkotlin/Function0;", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "client", "Lorg/eclipse/paho/mqttv5/client/MqttAsyncClient;", "subscribedTopics", "", "Lkotlin/Function2;", "", "disconnect", "getDeviceIdCommandsSubscribed", "", "getSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "caCrtFile", "crtFile", "keyFile", "password", "", "resubscribe", "sendMessage", "topic", "message", "qos", "", "subscribe", "callback", "subscribeToDeviceCommands", "id", "unsubscribe", "unsubscribeToDeviceCommands", "dl-client-sdk"})
@SourceDebugExtension(value={"SMAP\nPahoHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PahoHelper.kt\ncom/datalogic/agent/mqtt/PahoHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,296:1\n215#2,2:297\n766#3:299\n857#3,2:300\n1549#3:302\n1620#3,3:303\n*S KotlinDebug\n*F\n+ 1 PahoHelper.kt\ncom/datalogic/agent/mqtt/PahoHelper\n*L\n155#1:297,2\n214#1:299\n214#1:300,2\n215#1:302\n215#1:303,3\n*E\n"})
public final class PahoHelper
implements Logging,
IMqttHelper {
    @NotNull
    private MqttAsyncClient client;
    @NotNull
    private final Map<String, Function2<String, byte[], Unit>> subscribedTopics;

    public PahoHelper(@NotNull String clientId, @NotNull String mqttHost, @Nullable String mqttUsername, @Nullable String mqttPassword, @Nullable String caFilePath, @Nullable String clientCrtFilePath, @Nullable String clientKeyFilePath, final @Nullable Function0<Unit> onConnectionSuccess) {
        block8: {
            Intrinsics.checkNotNullParameter(clientId, "clientId");
            Intrinsics.checkNotNullParameter(mqttHost, "mqttHost");
            this.subscribedTopics = new LinkedHashMap();
            MemoryPersistence persistence = new MemoryPersistence();
            MqttConnectionOptions connOpts = new MqttConnectionOptions();
            connOpts.setAutomaticReconnect(true);
            connOpts.setCleanStart(true);
            connOpts.setConnectionTimeout(10);
            connOpts.setExecutorServiceTimeout(30);
            String finalMqtthost = mqttHost;
            if (mqttUsername != null && mqttPassword != null) {
                connOpts.setUserName(mqttUsername);
                String string = mqttPassword;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                connOpts.setPassword(byArray);
            }
            if (caFilePath != null && clientCrtFilePath != null && clientKeyFilePath != null) {
                if (new File(caFilePath).exists() && new File(clientCrtFilePath).exists() && new File(clientKeyFilePath).exists()) {
                    this.getLogger().warn("Certificates found. TLS enabled");
                    char[] cArray = new char[]{'T', 'j', 'h', '9', 'K', 'R', 'L', 'n', 'B', 'h', 'V', 'U', 'Q', 'q'};
                    SSLSocketFactory socketFactory = this.getSocketFactory(caFilePath, clientCrtFilePath, clientKeyFilePath, cArray);
                    connOpts.setSocketFactory(socketFactory);
                    if (StringsKt.startsWith$default(mqttHost, "tcp", false, 2, null)) {
                        this.getLogger().warn("Configuration error. Mqtt host " + mqttHost + " uses TCP protocol while using certificates. Replacing host with " + finalMqtthost);
                        finalMqtthost = StringsKt.replaceFirst$default(mqttHost, "tcp", "ssl", false, 4, null);
                    }
                } else {
                    this.getLogger().warn("Certificates not found. TLS disabled");
                }
            }
            this.client = new MqttAsyncClient(finalMqtthost, clientId, persistence);
            this.getLogger().info("Connecting to broker: " + mqttHost);
            while (!this.client.isConnected()) {
                try {
                    this.client.connect(connOpts);
                    if (this.client.isConnected()) continue;
                    this.getLogger().error("Mqtt connection failed. Retrying in 3 seconds");
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    this.getLogger().error("Mqtt connection exception. Retrying in 30 seconds", (Throwable)e);
                    Thread.sleep(30000L);
                }
            }
            this.getLogger().info("Connected to MQTT");
            this.client.setCallback(new MqttCallback(){

                @Override
                public void disconnected(@Nullable MqttDisconnectResponse p0) {
                    MqttDisconnectResponse mqttDisconnectResponse = p0;
                    this.getLogger().error("Connection lost error", (Throwable)(mqttDisconnectResponse != null ? mqttDisconnectResponse.getException() : null));
                }

                @Override
                public void mqttErrorOccurred(@Nullable MqttException p0) {
                    this.getLogger().error("Connection lost error", (Throwable)p0);
                }

                @Override
                public void messageArrived(@Nullable String string, @Nullable MqttMessage mm4) {
                }

                @Override
                public void deliveryComplete(@Nullable IMqttToken p0) {
                }

                @Override
                public void connectComplete(boolean automaticReconnection, @Nullable String serverUri) {
                    block0: {
                        this.getLogger().info("Mqtt client connected");
                        this.getLogger().info("Is an automatic reconnection: " + automaticReconnection);
                        this.resubscribe();
                        Function0<Unit> function0 = onConnectionSuccess;
                        if (function0 == null) break block0;
                        function0.invoke();
                    }
                }

                @Override
                public void authPacketArrived(int p0, @Nullable MqttProperties p1) {
                }
            });
            this.getLogger().info("Mqtt client connected");
            Function0<Unit> function0 = onConnectionSuccess;
            if (function0 == null) break block8;
            function0.invoke();
        }
    }

    public /* synthetic */ PahoHelper(String string, String string2, String string3, String string4, String string5, String string6, String string7, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string8 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue(string8, "randomUUID().toString()");
            string = string8;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        if ((n & 0x40) != 0) {
            string7 = null;
        }
        if ((n & 0x80) != 0) {
            function0 = null;
        }
        this(string, string2, string3, string4, string5, string6, string7, function0);
    }

    private final void resubscribe() {
        Map<String, Function2<String, byte[], Unit>> $this$forEach$iv = this.subscribedTopics;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Function2<String, byte[], Unit>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Function2<String, byte[], Unit>> element$iv;
            Map.Entry<String, Function2<String, byte[], Unit>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String topic = entry.getKey();
            Function2<String, byte[], Unit> callback2 = entry.getValue();
            try {
                this.subscribe(topic, callback2);
            }
            catch (MqttException e) {
                this.getLogger().error("Failed to resubscribe to previous topics", (Throwable)e);
            }
        }
    }

    @Override
    public void disconnect() {
        this.getLogger().info("Disconnecting MQTT");
        this.client.disconnect();
    }

    @Override
    public void sendMessage(@NotNull String topic, @NotNull String message, int qos) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(message, "message");
        this.getLogger().info("Sending message " + message + " on topic " + topic);
        MqttMessage mqttMessage = new MqttMessage();
        mqttMessage.setQos(qos);
        String string = message;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        mqttMessage.setPayload(byArray);
        OpenTelemetryUtils.INSTANCE.injectContext(mqttMessage);
        this.client.publish(topic, mqttMessage);
    }

    @Override
    public void subscribe(@NotNull String topic, @NotNull Function2<? super String, ? super byte[], Unit> callback2) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(callback2, "callback");
        this.getLogger().info("Subscribing to topic " + topic);
        try {
            Object[] objectArray = new MqttSubscription[]{new MqttSubscription(topic)};
            MqttSubscription[] mqttSubscriptionArray = objectArray;
            objectArray = new IMqttMessageListener[]{(arg_0, arg_1) -> PahoHelper.subscribe$lambda$2(callback2, arg_0, arg_1)};
            this.client.subscribe(mqttSubscriptionArray, null, null, (IMqttMessageListener[])objectArray, new MqttProperties());
            this.subscribedTopics.put(topic, callback2);
        }
        catch (MqttException e) {
            this.getLogger().error("Mqtt subscription failed", (Throwable)e);
        }
    }

    @Override
    public void subscribeToDeviceCommands(@NotNull String id, @NotNull Function2<? super String, ? super byte[], Unit> callback2) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(callback2, "callback");
        String deviceCommandTopic = Utils.INSTANCE.getCommandTopicFromDeviceId(id);
        this.getLogger().info("Subscribing to device commands topic " + deviceCommandTopic);
        this.subscribe(deviceCommandTopic, callback2);
    }

    @Override
    public void unsubscribeToDeviceCommands(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        String deviceCommandTopic = Utils.INSTANCE.getCommandTopicFromDeviceId(id);
        this.getLogger().info("Unsubscribing to device commands topic " + deviceCommandTopic);
        this.unsubscribe(deviceCommandTopic);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getDeviceIdCommandsSubscribed() {
        void $this$mapTo$iv$iv;
        String topic;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.subscribedTopics.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            topic = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)topic, "command", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            topic = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Utils.INSTANCE.getDeviceFromTopic(topic));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    public void unsubscribe(@NotNull String topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        this.getLogger().info("Unsubscribing from topic " + topic);
        this.client.unsubscribe(topic);
        this.subscribedTopics.remove(topic);
    }

    private final SSLSocketFactory getSocketFactory(String caCrtFile, String crtFile, String keyFile, char[] password) throws Exception {
        Serializable privateKey;
        Serializable serializable;
        Security.addProvider(new BouncyCastleProvider());
        X509Certificate caCert = null;
        FileInputStream fis = new FileInputStream(caCrtFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        while (bis.available() > 0) {
            Certificate certificate = cf.generateCertificate(bis);
            Intrinsics.checkNotNull(certificate, "null cannot be cast to non-null type java.security.cert.X509Certificate");
            caCert = (X509Certificate)certificate;
        }
        bis = new BufferedInputStream(new FileInputStream(crtFile));
        X509Certificate cert = null;
        while (bis.available() > 0) {
            Certificate certificate = cf.generateCertificate(bis);
            Intrinsics.checkNotNull(certificate, "null cannot be cast to non-null type java.security.cert.X509Certificate");
            cert = (X509Certificate)certificate;
        }
        PEMParser pemParser = new PEMParser(new FileReader(keyFile));
        Object object = pemParser.readObject();
        Intrinsics.checkNotNullExpressionValue(object, "pemParser.readObject()");
        Object pemObject = object;
        char[] cArray = password;
        if (password == null) {
            cArray = new char[]{};
        }
        char[] passToCharArray = cArray;
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter().setProvider("BC");
        Intrinsics.checkNotNullExpressionValue(jcaPEMKeyConverter, "JcaPEMKeyConverter()\n   \u2026       .setProvider(\"BC\")");
        JcaPEMKeyConverter converter = jcaPEMKeyConverter;
        if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
            this.getLogger().info("Encrypted key - we will use provided password");
            InputDecryptorProvider decryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passToCharArray);
            PrivateKeyInfo decryptPrivateKeyInfo = ((PKCS8EncryptedPrivateKeyInfo)pemObject).decryptPrivateKeyInfo(decryptorProvider);
            PrivateKey privateKey2 = converter.getPrivateKey(decryptPrivateKeyInfo);
            serializable = new KeyPair(null, privateKey2);
        } else if (pemObject instanceof PrivateKeyInfo) {
            privateKey = converter.getPrivateKey((PrivateKeyInfo)pemObject);
            serializable = new KeyPair(null, (PrivateKey)privateKey);
        } else {
            System.out.println((Object)"Unencrypted key - no password needed");
            privateKey = converter.getKeyPair((PEMKeyPair)pemObject);
            Intrinsics.checkNotNullExpressionValue(privateKey, "{\n            println(\"U\u2026 as PEMKeyPair)\n        }");
            serializable = privateKey;
        }
        KeyPair key2 = serializable;
        pemParser.close();
        KeyStore caKs = KeyStore.getInstance(KeyStore.getDefaultType());
        caKs.load(null, null);
        caKs.setCertificateEntry("ca-certificate", caCert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
        Intrinsics.checkNotNullExpressionValue(trustManagerFactory, "getInstance(\"X509\")");
        TrustManagerFactory tmf = trustManagerFactory;
        tmf.init(caKs);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        ks.setCertificateEntry("certificate", cert);
        X509Certificate[] x509CertificateArray = new X509Certificate[]{cert};
        ks.setKeyEntry("private-key", key2.getPrivate(), passToCharArray, x509CertificateArray);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        Intrinsics.checkNotNullExpressionValue(keyManagerFactory, "getInstance(\n           \u2026aultAlgorithm()\n        )");
        KeyManagerFactory kmf = keyManagerFactory;
        kmf.init(ks, passToCharArray);
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLSv1.2\")");
        SSLContext context = sSLContext;
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        SSLSocketFactory sSLSocketFactory = context.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "context.socketFactory");
        return sSLSocketFactory;
    }

    @Override
    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger(this);
    }

    private static final void subscribe$lambda$2$lambda$1(Function2 $callback, String $subTopic, MqttMessage $message) {
        Intrinsics.checkNotNullParameter($callback, "$callback");
        Intrinsics.checkNotNullParameter($subTopic, "$subTopic");
        Intrinsics.checkNotNullParameter($message, "$message");
        byte[] byArray = $message.getPayload();
        Intrinsics.checkNotNullExpressionValue(byArray, "message.payload");
        $callback.invoke($subTopic, byArray);
    }

    private static final void subscribe$lambda$2(Function2 $callback, String subTopic, MqttMessage message) {
        Intrinsics.checkNotNullParameter($callback, "$callback");
        Intrinsics.checkNotNullParameter(subTopic, "subTopic");
        Intrinsics.checkNotNullParameter(message, "message");
        OpenTelemetryUtils.INSTANCE.startMqttMessageSpan(message, subTopic, () -> PahoHelper.subscribe$lambda$2$lambda$1($callback, subTopic, message));
    }
}

