/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.agent.utils;

import com.datalogic.agent.utils.FileUtilsKt;
import com.datalogic.agent.utils.OpenTelemetryUtils;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/datalogic/agent/utils/OpenTelemetryUtils;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "mqttMessageGetter", "Lio/opentelemetry/context/propagation/TextMapGetter;", "Lorg/eclipse/paho/mqttv5/common/MqttMessage;", "mqttMessageSetter", "Lio/opentelemetry/context/propagation/TextMapSetter;", "openTelemetry", "Lio/opentelemetry/api/OpenTelemetry;", "getOpenTelemetry", "()Lio/opentelemetry/api/OpenTelemetry;", "initConfigFile", "", "injectContext", "msg", "startMqttMessageSpan", "message", "topic", "", "executeInSpan", "Ljava/lang/Runnable;", "dl-client-sdk"})
public final class OpenTelemetryUtils
implements Logging {
    @NotNull
    public static final OpenTelemetryUtils INSTANCE = new OpenTelemetryUtils();
    @NotNull
    private static final OpenTelemetry openTelemetry;
    @NotNull
    private static final TextMapGetter<MqttMessage> mqttMessageGetter;
    @NotNull
    private static final TextMapSetter<MqttMessage> mqttMessageSetter;

    private OpenTelemetryUtils() {
    }

    @NotNull
    public final OpenTelemetry getOpenTelemetry() {
        return openTelemetry;
    }

    public final void initConfigFile() {
        File configFile = new File("otel.properties");
        if (!configFile.exists()) {
            boolean writable = configFile.setWritable(true, false);
            if (!writable) {
                this.getLogger().warn("Otel configuration file not writable without admin rights ");
            }
            FileUtilsKt.copyFileFromResource("otel.properties", configFile);
            String string = configFile.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "configFile.path");
            FileUtilsKt.setWritePermission(string);
        }
    }

    public final void injectContext(@Nullable MqttMessage msg) {
        GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), msg, mqttMessageSetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startMqttMessageSpan(@NotNull MqttMessage message, @NotNull String topic, @NotNull Runnable executeInSpan) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(executeInSpan, "executeInSpan");
        Tracer tracer = GlobalOpenTelemetry.getTracer("global");
        Intrinsics.checkNotNullExpressionValue(tracer, "getTracer(\"global\")");
        Tracer tracer2 = tracer;
        Context context = GlobalOpenTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), message, mqttMessageGetter);
        Intrinsics.checkNotNullExpressionValue(context, "getPropagators().textMap\u2026ssage, mqttMessageGetter)");
        Context extractedContext = context;
        SpanBuilder spanBuilder = tracer2.spanBuilder("MQTT " + topic).setSpanKind(SpanKind.CONSUMER).setParent(extractedContext).setAttribute("topic", topic);
        byte[] byArray = message.getPayload();
        Intrinsics.checkNotNullExpressionValue(byArray, "message.payload");
        Object object = byArray;
        Object object2 = spanBuilder.setAttribute("message", new String((byte[])object, Charsets.UTF_8)).startSpan();
        Intrinsics.checkNotNullExpressionValue(object2, "tracer.spanBuilder(\"MQTT\u2026\n            .startSpan()");
        Span serverSpan = object2;
        try {
            object2 = extractedContext.makeCurrent();
            object = null;
            try {
                Scope cfr_ignored_0 = (Scope)object2;
                boolean bl = false;
                AutoCloseable autoCloseable = serverSpan.makeCurrent();
                Throwable throwable = null;
                try {
                    Scope cfr_ignored_1 = (Scope)autoCloseable;
                    boolean bl2 = false;
                    executeInSpan.run();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object);
            }
        }
        finally {
            serverSpan.end();
        }
    }

    @Override
    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger(this);
    }

    private static final void mqttMessageSetter$lambda$0(MqttMessage carrier, String key2, String value2) {
        block2: {
            Object object;
            List<UserProperty> mqttUserProperties;
            MqttMessage mqttMessage = carrier;
            if (mqttMessage != null) {
                mqttMessage.setProperties(new MqttProperties());
            }
            MqttMessage mqttMessage2 = carrier;
            MqttProperties mqttProperties = mqttMessage2 != null ? mqttMessage2.getProperties() : null;
            if (mqttProperties != null) {
                mqttProperties.setUserProperties(new ArrayList());
            }
            List<UserProperty> list = mqttUserProperties = (object = carrier) != null && (object = ((MqttMessage)object).getProperties()) != null ? ((MqttProperties)object).getUserProperties() : null;
            if (list == null) break block2;
            list.add(new UserProperty(key2, value2));
        }
    }

    static {
        AutoConfiguredOpenTelemetrySdk.initialize();
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        Intrinsics.checkNotNullExpressionValue(openTelemetry, "get()");
        OpenTelemetryUtils.openTelemetry = openTelemetry;
        mqttMessageGetter = new TextMapGetter<MqttMessage>(){

            @NotNull
            public Iterable<String> keys(@NotNull MqttMessage msg) {
                Intrinsics.checkNotNullParameter(msg, "msg");
                List<UserProperty> userProperties = msg.getProperties().getUserProperties();
                Stream<String> stream = userProperties.stream().map(arg_0 -> mqttMessageGetter.1.keys$lambda$0(mqttMessageGetter.keys.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue(stream, "userProperties.stream().map(UserProperty::getKey)");
                return StreamsKt.toList(stream);
            }

            @Nullable
            public String get(@Nullable MqttMessage msg, @NotNull String key2) {
                UserProperty userProperty;
                UserProperty userProperty2;
                List<UserProperty> userProperties;
                Intrinsics.checkNotNullParameter(key2, "key");
                Object object = msg;
                List<UserProperty> list = userProperties = object != null && (object = ((MqttMessage)object).getProperties()) != null ? ((MqttProperties)object).getUserProperties() : null;
                if (list != null) {
                    Object v2;
                    block3: {
                        Iterable $this$firstOrNull$iv = list;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            UserProperty userProperty3 = (UserProperty)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(userProperty3.getKey(), key2)) continue;
                            v2 = element$iv;
                            break block3;
                        }
                        v2 = null;
                    }
                    userProperty2 = v2;
                } else {
                    userProperty2 = null;
                }
                UserProperty userProperty4 = userProperty = userProperty2;
                String stringValue = userProperty4 != null ? userProperty4.getValue() : null;
                OpenTelemetryUtils.INSTANCE.getLogger().debug("Opentelemetry Key " + key2 + ": Value " + stringValue);
                return stringValue;
            }

            private static final String keys$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (String)$tmp0.invoke(p0);
            }
        };
        mqttMessageSetter = OpenTelemetryUtils::mqttMessageSetter$lambda$0;
    }
}

