/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite;

import com.sksamuel.hoplite.ClasspathResourceLoader;
import com.sksamuel.hoplite.ConfigFailure;
import com.sksamuel.hoplite.ConfigSource;
import com.sksamuel.hoplite.FpKt;
import com.sksamuel.hoplite.fp.Validated;
import com.sksamuel.hoplite.fp.ValidatedKt;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 \u000e2\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H&J*\u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\u0010"}, d2={"Lcom/sksamuel/hoplite/ConfigSource;", "", "()V", "describe", "", "ext", "open", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "Ljava/io/InputStream;", "Lcom/sksamuel/hoplite/ConfigResult;", "optional", "", "ClasspathSource", "Companion", "PathSource", "hoplite-core"})
public abstract class ConfigSource {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract Validated<ConfigFailure, InputStream> open(boolean var1);

    @NotNull
    public abstract String describe();

    @NotNull
    public abstract String ext();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J*\u0010\n\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bj\n\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/sksamuel/hoplite/ConfigSource$PathSource;", "Lcom/sksamuel/hoplite/ConfigSource;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "describe", "", "ext", "open", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "Ljava/io/InputStream;", "Lcom/sksamuel/hoplite/ConfigResult;", "optional", "", "hoplite-core"})
    public static final class PathSource
    extends ConfigSource {
        @NotNull
        private final Path path;

        public PathSource(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.path = path;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public String describe() {
            return ((Object)this.path).toString();
        }

        @Override
        @NotNull
        public String ext() {
            char[] cArray = new char[]{'.'};
            return (String)CollectionsKt.last(StringsKt.split$default((CharSequence)((Object)this.path.getFileName()).toString(), cArray, false, 0, 6, null));
        }

        @Override
        @NotNull
        public Validated<ConfigFailure, InputStream> open(boolean optional) {
            Validated validated;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Object object;
                PathSource pathSource = this;
                try {
                    PathSource $this$open_u24lambda_u2d0 = pathSource;
                    boolean bl = false;
                    object = Result.constructor-impl(Files.newInputStream($this$open_u24lambda_u2d0.path, new OpenOption[0]));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                validated = FpKt.toValidated(object, (Function1)new Function1<Throwable, ConfigFailure.ErrorOpeningPath>(this){
                    final /* synthetic */ PathSource this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final ConfigFailure.ErrorOpeningPath invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return new ConfigFailure.ErrorOpeningPath(this.this$0.getPath());
                    }
                });
            } else {
                validated = optional ? ValidatedKt.valid(null) : ValidatedKt.invalid(new ConfigFailure.UnknownPath(this.path));
            }
            return validated;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J*\u0010\t\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nj\n\u0012\u0006\u0012\u0004\u0018\u00010\f`\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/sksamuel/hoplite/ConfigSource$ClasspathSource;", "Lcom/sksamuel/hoplite/ConfigSource;", "resource", "", "classpathResourceLoader", "Lcom/sksamuel/hoplite/ClasspathResourceLoader;", "(Ljava/lang/String;Lcom/sksamuel/hoplite/ClasspathResourceLoader;)V", "describe", "ext", "open", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "Ljava/io/InputStream;", "Lcom/sksamuel/hoplite/ConfigResult;", "optional", "", "hoplite-core"})
    public static final class ClasspathSource
    extends ConfigSource {
        @NotNull
        private final String resource;
        @NotNull
        private final ClasspathResourceLoader classpathResourceLoader;

        public ClasspathSource(@NotNull String resource, @NotNull ClasspathResourceLoader classpathResourceLoader) {
            Intrinsics.checkNotNullParameter(resource, "resource");
            Intrinsics.checkNotNullParameter(classpathResourceLoader, "classpathResourceLoader");
            this.resource = resource;
            this.classpathResourceLoader = classpathResourceLoader;
        }

        public /* synthetic */ ClasspathSource(String string, ClasspathResourceLoader classpathResourceLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                classpathResourceLoader = ClasspathResourceLoader.Companion.toClasspathResourceLoader(Companion.class);
            }
            this(string, classpathResourceLoader);
        }

        @Override
        @NotNull
        public String describe() {
            return "classpath:" + this.resource;
        }

        @Override
        @NotNull
        public String ext() {
            char[] cArray = new char[]{'.'};
            return (String)CollectionsKt.last(StringsKt.split$default((CharSequence)this.resource, cArray, false, 0, 6, null));
        }

        @Override
        @NotNull
        public Validated<ConfigFailure, InputStream> open(boolean optional) {
            InputStream input = this.classpathResourceLoader.getResourceAsStream(this.resource);
            InputStream inputStream2 = input;
            return inputStream2 != null ? ValidatedKt.valid(inputStream2) : (optional ? ValidatedKt.valid(null) : ValidatedKt.invalid(new ConfigFailure.UnknownSource(this.resource)));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a$\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fJ6\u0010\r\u001a$\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006J6\u0010\u0010\u001a$\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006J.\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004j\b\u0012\u0004\u0012\u00020\u0007`\b2\u0006\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ@\u0010\u0013\u001a$\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"Lcom/sksamuel/hoplite/ConfigSource$Companion;", "", "()V", "fromClasspathResources", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "", "Lcom/sksamuel/hoplite/ConfigSource;", "Lcom/sksamuel/hoplite/ConfigResult;", "resources", "", "classpathResourceLoader", "Lcom/sksamuel/hoplite/ClasspathResourceLoader;", "fromFiles", "files", "Ljava/io/File;", "fromPaths", "paths", "Ljava/nio/file/Path;", "fromResourcesOrFiles", "resourceOrFile", "resourceOrFiles", "hoplite-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Validated<ConfigFailure, ConfigSource> fromResourcesOrFiles(@NotNull String resourceOrFile, @NotNull ClasspathResourceLoader classpathResourceLoader) {
            Validated validated;
            Intrinsics.checkNotNullParameter(resourceOrFile, "resourceOrFile");
            Intrinsics.checkNotNullParameter(classpathResourceLoader, "classpathResourceLoader");
            Path path = Paths.get(resourceOrFile, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "path");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                validated = ValidatedKt.valid(new PathSource(path));
                return validated;
            }
            InputStream inputStream2 = classpathResourceLoader.getResourceAsStream(resourceOrFile);
            if (inputStream2 != null) {
                InputStream it = inputStream2;
                boolean bl = false;
                Validated validated2 = ValidatedKt.valid(new ClasspathSource(resourceOrFile, classpathResourceLoader));
                if (validated2 != null) {
                    validated = validated2;
                    return validated;
                }
            }
            validated = ValidatedKt.invalid(new ConfigFailure.UnknownSource(resourceOrFile));
            return validated;
        }

        public static /* synthetic */ Validated fromResourcesOrFiles$default(Companion companion, String string, ClasspathResourceLoader classpathResourceLoader, int n, Object object) {
            if ((n & 2) != 0) {
                classpathResourceLoader = ClasspathResourceLoader.Companion.toClasspathResourceLoader(Companion.class);
            }
            return companion.fromResourcesOrFiles(string, classpathResourceLoader);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Validated<ConfigFailure, List<ConfigSource>> fromResourcesOrFiles(@NotNull List<String> resourceOrFiles, @NotNull ClasspathResourceLoader classpathResourceLoader) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(resourceOrFiles, "resourceOrFiles");
            Intrinsics.checkNotNullParameter(classpathResourceLoader, "classpathResourceLoader");
            Iterable $this$map$iv = resourceOrFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.fromResourcesOrFiles((String)it, classpathResourceLoader));
            }
            return ValidatedKt.sequence((List)destination$iv$iv).mapInvalid(fromResourcesOrFiles.3.INSTANCE);
        }

        public static /* synthetic */ Validated fromResourcesOrFiles$default(Companion companion, List list, ClasspathResourceLoader classpathResourceLoader, int n, Object object) {
            if ((n & 2) != 0) {
                classpathResourceLoader = ClasspathResourceLoader.Companion.toClasspathResourceLoader(Companion.class);
            }
            return companion.fromResourcesOrFiles(list, classpathResourceLoader);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Validated<ConfigFailure, List<ConfigSource>> fromClasspathResources(@NotNull List<String> resources, @NotNull ClasspathResourceLoader classpathResourceLoader) {
            Intrinsics.checkNotNullParameter(resources, "resources");
            Intrinsics.checkNotNullParameter(classpathResourceLoader, "classpathResourceLoader");
            $this$map$iv = resources;
            $i$f$map = false;
            var5_5 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var10_10 = (String)item$iv$iv;
                var16_16 = destination$iv$iv;
                $i$a$-map-ConfigSource$Companion$fromClasspathResources$1 = false;
                var12_12 = classpathResourceLoader.getResourceAsStream((String)resource);
                if (var12_12 == null) ** GOTO lbl-1000
                it = var12_12;
                $i$a$-let-ConfigSource$Companion$fromClasspathResources$1$1 = false;
                var15_15 = ValidatedKt.valid(new ClasspathSource((String)resource, classpathResourceLoader));
                if (var15_15 != null) {
                    v0 = var15_15;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = ValidatedKt.invalid(new ConfigFailure.UnknownSource((String)resource));
                }
                var16_16.add(v0);
            }
            return ValidatedKt.sequence((List)destination$iv$iv).mapInvalid(fromClasspathResources.2.INSTANCE);
        }

        public static /* synthetic */ Validated fromClasspathResources$default(Companion companion, List list, ClasspathResourceLoader classpathResourceLoader, int n, Object object) {
            if ((n & 2) != 0) {
                classpathResourceLoader = ClasspathResourceLoader.Companion.toClasspathResourceLoader(Companion.class);
            }
            return companion.fromClasspathResources(list, classpathResourceLoader);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Validated<ConfigFailure, List<ConfigSource>> fromPaths(@NotNull List<? extends Path> paths) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(paths, "paths");
            Iterable $this$map$iv = paths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Validated validated;
                void path;
                Object $this$fromPaths_u24lambda_u2d7_u24lambda_u2d4;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = Companion;
                try {
                    $this$fromPaths_u24lambda_u2d7_u24lambda_u2d4 = object;
                    boolean bl2 = false;
                    $this$fromPaths_u24lambda_u2d7_u24lambda_u2d4 = Result.constructor-impl(Files.newInputStream((Path)path, new OpenOption[0]));
                }
                catch (Throwable bl2) {
                    $this$fromPaths_u24lambda_u2d7_u24lambda_u2d4 = Result.constructor-impl(ResultKt.createFailure(bl2));
                }
                object = $this$fromPaths_u24lambda_u2d7_u24lambda_u2d4;
                if (Result.exceptionOrNull-impl(object) == null) {
                    InputStream it = (InputStream)object;
                    boolean bl3 = false;
                    validated = ValidatedKt.valid(new PathSource((Path)path));
                } else {
                    boolean bl4 = false;
                    validated = ValidatedKt.invalid(new ConfigFailure.UnknownSource(path.toString()));
                }
                collection.add(validated);
            }
            return ValidatedKt.sequence((List)destination$iv$iv).mapInvalid(fromPaths.2.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Validated<ConfigFailure, List<ConfigSource>> fromFiles(@NotNull List<? extends File> files) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(files, "files");
            Iterable iterable = files;
            Companion companion = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toPath());
            }
            return companion.fromPaths((List)destination$iv$iv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

