/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.sources;

import com.sksamuel.hoplite.ConfigFailure;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.PropertySource;
import com.sksamuel.hoplite.PropertySourceContext;
import com.sksamuel.hoplite.Undefined;
import com.sksamuel.hoplite.fp.Validated;
import com.sksamuel.hoplite.fp.ValidatedKt;
import com.sksamuel.hoplite.parsers.Parser;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/sksamuel/hoplite/sources/XdgConfigPropertySource;", "Lcom/sksamuel/hoplite/PropertySource;", "()V", "node", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "Lcom/sksamuel/hoplite/Node;", "Lcom/sksamuel/hoplite/ConfigResult;", "context", "Lcom/sksamuel/hoplite/PropertySourceContext;", "path", "Ljava/nio/file/Path;", "ext", "", "source", "hoplite-core"})
public final class XdgConfigPropertySource
implements PropertySource {
    @NotNull
    public static final XdgConfigPropertySource INSTANCE = new XdgConfigPropertySource();

    private XdgConfigPropertySource() {
    }

    @Override
    @NotNull
    public String source() {
        return "$XDG_CONFIG_HOME/hoplite.<ext>";
    }

    private final Path path(String ext) {
        String xdg = System.getenv("XDG_CONFIG_HOME");
        CharSequence charSequence = xdg;
        return charSequence == null || StringsKt.isBlank(charSequence) ? null : Paths.get(xdg, new String[0]).resolve("hoplite." + ext);
    }

    @Override
    @NotNull
    public Validated<ConfigFailure, Node> node(@NotNull PropertySourceContext context) {
        Validated validated;
        Path path;
        block5: {
            Path path2;
            Intrinsics.checkNotNullParameter(context, "context");
            for (String ext : (Iterable)context.getParsers().registeredExtensions()) {
                Path path3;
                boolean bl;
                Path path4;
                boolean bl2 = false;
                Path it = path4 = INSTANCE.path(ext);
                boolean bl3 = false;
                Path path5 = it;
                if (path5 != null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    bl = Files.exists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                } else {
                    bl = false;
                }
                if ((path3 = bl ? path4 : null) == null) continue;
                path2 = path3;
                break block5;
            }
            path2 = path = null;
        }
        if (path == null) {
            validated = ValidatedKt.valid(Undefined.INSTANCE);
        } else {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream2 = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(this, *options)");
            InputStream input = inputStream2;
            validated = context.getParsers().locate(PathsKt.getExtension(path)).map((Function1)new Function1<Parser, Node>(input, path){
                final /* synthetic */ InputStream $input;
                final /* synthetic */ Path $path;
                {
                    this.$input = $input;
                    this.$path = $path;
                    super(1);
                }

                @NotNull
                public final Node invoke(@NotNull Parser it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.load(this.$input, ((Object)this.$path).toString());
                }
            });
        }
        return validated;
    }
}

