/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.apache;

import io.ktor.client.call.UnsupportedContentTypeException;
import io.ktor.client.engine.UtilsKt;
import io.ktor.client.engine.apache.ApacheEngineConfig;
import io.ktor.client.engine.apache.ApacheHttpRequestKt;
import io.ktor.client.engine.apache.ApacheRequestProducerKt;
import io.ktor.client.engine.apache.InterestControllerHolder;
import io.ktor.client.request.HttpRequestData;
import io.ktor.http.HttpMethod;
import io.ktor.http.URLUtilsJvmKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.CoroutinesKt;
import io.ktor.utils.io.WriterScope;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.JobKt;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\u001a2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001aH\u0016J\b\u0010-\u001a\u00020\u0018H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/ktor/client/engine/apache/ApacheRequestProducer;", "Lorg/apache/http/nio/protocol/HttpAsyncRequestProducer;", "Lkotlinx/coroutines/CoroutineScope;", "requestData", "Lio/ktor/client/request/HttpRequestData;", "config", "Lio/ktor/client/engine/apache/ApacheEngineConfig;", "callContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/client/request/HttpRequestData;Lio/ktor/client/engine/apache/ApacheEngineConfig;Lkotlin/coroutines/CoroutineContext;)V", "channel", "Lio/ktor/utils/io/ByteReadChannel;", "getChannel$annotations", "()V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "host", "Lorg/apache/http/HttpHost;", "interestController", "Lio/ktor/client/engine/apache/InterestControllerHolder;", "producerJob", "Lkotlinx/coroutines/CompletableJob;", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "close", "", "failed", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "generateRequest", "Lorg/apache/http/HttpRequest;", "getTarget", "isRepeatable", "", "produceContent", "encoder", "Lorg/apache/http/nio/ContentEncoder;", "ioctrl", "Lorg/apache/http/nio/IOControl;", "requestCompleted", "context", "Lorg/apache/http/protocol/HttpContext;", "resetRequest", "setupRequest", "ktor-client-apache"})
@SourceDebugExtension(value={"SMAP\nApacheRequestProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApacheRequestProducer.kt\nio/ktor/client/engine/apache/ApacheRequestProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class ApacheRequestProducer
implements HttpAsyncRequestProducer,
CoroutineScope {
    @NotNull
    private final HttpRequestData requestData;
    @NotNull
    private final ApacheEngineConfig config;
    @NotNull
    private final HttpUriRequest request;
    @NotNull
    private final HttpHost host;
    @NotNull
    private final InterestControllerHolder interestController;
    @NotNull
    private final CompletableJob producerJob;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final ByteReadChannel channel;

    public ApacheRequestProducer(@NotNull HttpRequestData requestData, @NotNull ApacheEngineConfig config2, @NotNull CoroutineContext callContext) {
        ByteReadChannel byteReadChannel;
        Intrinsics.checkNotNullParameter(requestData, "requestData");
        Intrinsics.checkNotNullParameter(config2, "config");
        Intrinsics.checkNotNullParameter(callContext, "callContext");
        this.requestData = requestData;
        this.config = config2;
        this.request = this.setupRequest();
        HttpHost httpHost = URIUtils.extractHost(this.request.getURI());
        if (httpHost == null) {
            throw new IllegalArgumentException("Cannot extract host from URL " + this.request.getURI());
        }
        this.host = httpHost;
        this.interestController = new InterestControllerHolder();
        this.producerJob = JobKt.Job$default(null, 1, null);
        this.coroutineContext = callContext.plus(this.producerJob);
        OutgoingContent body2 = this.requestData.getBody();
        if (body2 instanceof OutgoingContent.ByteArrayContent) {
            byteReadChannel = ByteChannelCtorKt.ByteReadChannel(((OutgoingContent.ByteArrayContent)body2).bytes());
        } else {
            if (body2 instanceof OutgoingContent.ProtocolUpgrade) {
                throw new UnsupportedContentTypeException(body2);
            }
            if (body2 instanceof OutgoingContent.NoContent) {
                byteReadChannel = ByteReadChannel.Companion.getEmpty();
            } else if (body2 instanceof OutgoingContent.ReadChannelContent) {
                byteReadChannel = ((OutgoingContent.ReadChannelContent)body2).readFrom();
            } else if (body2 instanceof OutgoingContent.WriteChannelContent) {
                byteReadChannel = CoroutinesKt.writer((CoroutineScope)GlobalScope.INSTANCE, callContext, true, (Function2<? super WriterScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<WriterScope, Continuation<? super Unit>, Object>(body2, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ OutgoingContent $body;
                    {
                        this.$body = $body;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                WriterScope $this$writer = (WriterScope)this.L$0;
                                this.label = 1;
                                Object object3 = ((OutgoingContent.WriteChannelContent)this.$body).writeTo($this$writer.getChannel(), this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        Function2<WriterScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value2;
                        return (Continuation)((Object)function2);
                    }

                    @Nullable
                    public final Object invoke(@NotNull WriterScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }).getChannel();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.channel = byteReadChannel;
        this.producerJob.invokeOnCompletion((Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(){

            @Override
            public final void invoke(@Nullable Throwable cause) {
                channel.cancel(cause);
            }
        });
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private static /* synthetic */ void getChannel$annotations() {
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    @NotNull
    public HttpHost getTarget() {
        return this.host;
    }

    @Override
    @NotNull
    public HttpRequest generateRequest() {
        return this.request;
    }

    @Override
    public void requestCompleted(@NotNull HttpContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
    }

    @Override
    public void resetRequest() {
    }

    @Override
    public void failed(@NotNull Exception cause) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        Exception mappedCause = ApacheHttpRequestKt.mapCause(cause, this.requestData);
        this.channel.cancel(mappedCause);
        this.producerJob.completeExceptionally(mappedCause);
    }

    @Override
    public void produceContent(@NotNull ContentEncoder encoder, @NotNull IOControl ioctrl) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(ioctrl, "ioctrl");
        if (this.interestController.getOutputSuspended()) {
            return;
        }
        int result2 = 0;
        while ((result2 = ByteReadChannel.DefaultImpls.readAvailable$default(this.channel, 0, new Function1<ByteBuffer, Unit>(encoder){
            final /* synthetic */ ContentEncoder $encoder;
            {
                this.$encoder = $encoder;
                super(1);
            }

            public final void invoke(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter(buffer, "buffer");
                this.$encoder.write(buffer);
            }
        }, 1, null)) > 0) {
        }
        if (this.channel.isClosedForRead()) {
            Throwable throwable = this.channel.getClosedCause();
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw it;
            }
            encoder.complete();
            return;
        }
        if (result2 == -1) {
            this.interestController.suspendOutput(ioctrl);
            BuildersKt.launch$default(this, Dispatchers.getUnconfined(), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ApacheRequestProducer this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = ApacheRequestProducer.access$getChannel$p(this.this$0).awaitContent(this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            try {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                ApacheRequestProducer.access$getInterestController$p(this.this$0).resumeOutputIfPossible();
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }
    }

    @Override
    public void close() {
        ByteReadChannelKt.cancel(this.channel);
        this.producerJob.complete();
    }

    /*
     * WARNING - void declaration
     */
    private final HttpUriRequest setupRequest() {
        HttpRequestData $this$setupRequest_u24lambda_u243 = this.requestData;
        boolean bl = false;
        RequestBuilder requestBuilder = RequestBuilder.create($this$setupRequest_u24lambda_u243.getMethod().getValue());
        Intrinsics.checkNotNull(requestBuilder);
        RequestBuilder builder = requestBuilder;
        builder.setUri(URLUtilsJvmKt.toURI($this$setupRequest_u24lambda_u243.getUrl()));
        OutgoingContent content2 = this.requestData.getBody();
        Ref.ObjectRef<String> length = new Ref.ObjectRef<String>();
        Ref.ObjectRef<String> type2 = new Ref.ObjectRef<String>();
        UtilsKt.mergeHeaders($this$setupRequest_u24lambda_u243.getHeaders(), content2, (Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(length, type2, builder){
            final /* synthetic */ Ref.ObjectRef<String> $length;
            final /* synthetic */ Ref.ObjectRef<String> $type;
            final /* synthetic */ RequestBuilder $builder;
            {
                this.$length = $length;
                this.$type = $type;
                this.$builder = $builder;
                super(2);
            }

            public final void invoke(@NotNull String key2, @NotNull String value2) {
                Intrinsics.checkNotNullParameter(key2, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                String string = key2;
                if (Intrinsics.areEqual(string, "Content-Length")) {
                    this.$length.element = value2;
                } else if (Intrinsics.areEqual(string, "Content-Type")) {
                    this.$type.element = value2;
                } else {
                    this.$builder.addHeader(key2, value2);
                }
            }
        });
        if (!Intrinsics.areEqual($this$setupRequest_u24lambda_u243.getMethod(), HttpMethod.Companion.getGet()) && !Intrinsics.areEqual($this$setupRequest_u24lambda_u243.getMethod(), HttpMethod.Companion.getHead()) || !($this$setupRequest_u24lambda_u243.getBody() instanceof OutgoingContent.NoContent)) {
            void $this$setupRequest_u24lambda_u243_u24lambda_u241;
            BasicHttpEntity basicHttpEntity;
            BasicHttpEntity basicHttpEntity2 = basicHttpEntity = new BasicHttpEntity();
            RequestBuilder requestBuilder2 = builder;
            boolean bl2 = false;
            String lengthResult = (String)length.element;
            CharSequence charSequence = lengthResult;
            if (charSequence == null || StringsKt.isBlank(charSequence)) {
                $this$setupRequest_u24lambda_u243_u24lambda_u241.setChunked(true);
            } else {
                $this$setupRequest_u24lambda_u243_u24lambda_u241.setContentLength(Long.parseLong(lengthResult));
            }
            $this$setupRequest_u24lambda_u243_u24lambda_u241.setContentType((String)type2.element);
            requestBuilder2.setEntity(basicHttpEntity);
        }
        ApacheEngineConfig $this$setupRequest_u24lambda_u243_u24lambda_u242 = this.config;
        boolean bl3 = false;
        Function1<RequestConfig.Builder, RequestConfig.Builder> function1 = $this$setupRequest_u24lambda_u243_u24lambda_u242.getCustomRequest();
        RequestConfig.Builder builder2 = RequestConfig.custom().setRedirectsEnabled($this$setupRequest_u24lambda_u243_u24lambda_u242.getFollowRedirects()).setSocketTimeout($this$setupRequest_u24lambda_u243_u24lambda_u242.getSocketTimeout()).setConnectTimeout($this$setupRequest_u24lambda_u243_u24lambda_u242.getConnectTimeout()).setConnectionRequestTimeout($this$setupRequest_u24lambda_u243_u24lambda_u242.getConnectionRequestTimeout());
        Intrinsics.checkNotNullExpressionValue(builder2, "custom()\n               \u2026connectionRequestTimeout)");
        builder.setConfig(ApacheRequestProducerKt.access$setupTimeoutAttributes(function1.invoke(builder2), this.requestData).build());
        HttpUriRequest httpUriRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue(httpUriRequest, "builder.build()");
        return httpUriRequest;
    }

    public static final /* synthetic */ InterestControllerHolder access$getInterestController$p(ApacheRequestProducer $this) {
        return $this.interestController;
    }
}

