/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B7\b\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011H\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/ktor/util/LRUCache;", "K", "V", "Ljava/util/LinkedHashMap;", "supplier", "Lkotlin/Function1;", "close", "", "maxSize", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;I)V", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "removeEldestEntry", "", "eldest", "", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nio/ktor/util/LRUCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    @NotNull
    private final Function1<K, V> supplier;
    @NotNull
    private final Function1<V, Unit> close;
    private final int maxSize;

    public LRUCache(@NotNull Function1<? super K, ? extends V> supplier, @NotNull Function1<? super V, Unit> close2, int maxSize) {
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        Intrinsics.checkNotNullParameter(close2, "close");
        super(10, 0.75f, true);
        this.supplier = supplier;
        this.close = close2;
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(@NotNull Map.Entry<? extends K, ? extends V> eldest) {
        boolean bl;
        Intrinsics.checkNotNullParameter(eldest, "eldest");
        boolean it = bl = this.size() > this.maxSize;
        boolean bl2 = false;
        if (it) {
            this.close.invoke(eldest.getValue());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key2) {
        V v;
        if (this.maxSize == 0) {
            v = this.supplier.invoke(key2);
        } else {
            LRUCache lRUCache = this;
            synchronized (lRUCache) {
                block6: {
                    boolean bl = false;
                    Object v2 = super.get(key2);
                    if (v2 == null) break block6;
                    Object it = v2;
                    boolean bl2 = false;
                    Object v3 = it;
                    return v3;
                }
                V it = this.supplier.invoke(key2);
                boolean bl = false;
                this.put(key2, it);
                V v4 = it;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 4] lbl24 : MonitorExitStatement: MONITOREXIT : var2_2
                v = v4;
            }
        }
        return v;
    }
}

