/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.propagation.Parser;
import io.opentelemetry.api.internal.PercentEscaper;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class W3CBaggagePropagator
implements TextMapPropagator {
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private static final W3CBaggagePropagator INSTANCE = new W3CBaggagePropagator();
    private static final PercentEscaper URL_ESCAPER = PercentEscaper.create();

    public static W3CBaggagePropagator getInstance() {
        return INSTANCE;
    }

    private W3CBaggagePropagator() {
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        Baggage baggage = Baggage.fromContext(context);
        if (baggage.isEmpty()) {
            return;
        }
        String headerContent = W3CBaggagePropagator.baggageToString(baggage);
        if (!headerContent.isEmpty()) {
            setter.set(carrier, FIELD, headerContent);
        }
    }

    private static String baggageToString(Baggage baggage) {
        StringBuilder headerContent = new StringBuilder();
        baggage.forEach((key2, baggageEntry) -> {
            if (W3CBaggagePropagator.baggageIsInvalid(key2, baggageEntry)) {
                return;
            }
            headerContent.append((String)key2).append("=").append(W3CBaggagePropagator.encodeValue(baggageEntry.getValue()));
            String metadataValue = baggageEntry.getMetadata().getValue();
            if (metadataValue != null && !metadataValue.isEmpty()) {
                headerContent.append(";").append(W3CBaggagePropagator.encodeValue(metadataValue));
            }
            headerContent.append(",");
        });
        if (headerContent.length() == 0) {
            return "";
        }
        headerContent.setLength(headerContent.length() - 1);
        return headerContent.toString();
    }

    private static String encodeValue(String value2) {
        return URL_ESCAPER.escape(value2);
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        String baggageHeader = getter.get(carrier, FIELD);
        if (baggageHeader == null) {
            return context;
        }
        if (baggageHeader.isEmpty()) {
            return context;
        }
        BaggageBuilder baggageBuilder = Baggage.builder();
        try {
            W3CBaggagePropagator.extractEntries(baggageHeader, baggageBuilder);
        }
        catch (RuntimeException e) {
            return context;
        }
        return context.with(baggageBuilder.build());
    }

    private static void extractEntries(String baggageHeader, BaggageBuilder baggageBuilder) {
        new Parser(baggageHeader).parseInto(baggageBuilder);
    }

    private static boolean baggageIsInvalid(String key2, BaggageEntry baggageEntry) {
        return !W3CBaggagePropagator.isValidBaggageKey(key2) || !W3CBaggagePropagator.isValidBaggageValue(baggageEntry.getValue());
    }

    private static boolean isValidBaggageKey(String name) {
        return name != null && !name.trim().isEmpty() && StringUtils.isPrintableString(name);
    }

    private static boolean isValidBaggageValue(String value2) {
        return value2 != null;
    }

    public String toString() {
        return "W3CBaggagePropagator";
    }
}

