/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface AttributeKey<T> {
    public String getKey();

    public AttributeType getType();

    public static AttributeKey<String> stringKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.STRING);
    }

    public static AttributeKey<Boolean> booleanKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.BOOLEAN);
    }

    public static AttributeKey<Long> longKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.LONG);
    }

    public static AttributeKey<Double> doubleKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.DOUBLE);
    }

    public static AttributeKey<List<String>> stringArrayKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.STRING_ARRAY);
    }

    public static AttributeKey<List<Boolean>> booleanArrayKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.BOOLEAN_ARRAY);
    }

    public static AttributeKey<List<Long>> longArrayKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.LONG_ARRAY);
    }

    public static AttributeKey<List<Double>> doubleArrayKey(String key2) {
        return InternalAttributeKeyImpl.create(key2, AttributeType.DOUBLE_ARRAY);
    }
}

