/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.logs;

import io.opentelemetry.api.incubator.logs.AnyValueArray;
import io.opentelemetry.api.incubator.logs.AnyValueBoolean;
import io.opentelemetry.api.incubator.logs.AnyValueBytes;
import io.opentelemetry.api.incubator.logs.AnyValueDouble;
import io.opentelemetry.api.incubator.logs.AnyValueLong;
import io.opentelemetry.api.incubator.logs.AnyValueString;
import io.opentelemetry.api.incubator.logs.AnyValueType;
import io.opentelemetry.api.incubator.logs.KeyAnyValue;
import io.opentelemetry.api.incubator.logs.KeyAnyValueList;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public interface AnyValue<T> {
    public static AnyValue<String> of(String value2) {
        return AnyValueString.create(value2);
    }

    public static AnyValue<Boolean> of(boolean value2) {
        return AnyValueBoolean.create(value2);
    }

    public static AnyValue<Long> of(long value2) {
        return AnyValueLong.create(value2);
    }

    public static AnyValue<Double> of(double value2) {
        return AnyValueDouble.create(value2);
    }

    public static AnyValue<ByteBuffer> of(byte[] value2) {
        return AnyValueBytes.create(value2);
    }

    public static AnyValue<List<AnyValue<?>>> of(AnyValue<?> ... value2) {
        return AnyValueArray.create(value2);
    }

    public static AnyValue<List<AnyValue<?>>> of(List<AnyValue<?>> value2) {
        return AnyValueArray.create(value2);
    }

    public static AnyValue<List<KeyAnyValue>> of(KeyAnyValue ... value2) {
        return KeyAnyValueList.create(value2);
    }

    public static AnyValue<List<KeyAnyValue>> of(Map<String, AnyValue<?>> value2) {
        return KeyAnyValueList.createFromMap(value2);
    }

    public AnyValueType getType();

    public T getValue();

    public String asString();
}

