/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.internal;

import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public final class ConfigUtil {
    private ConfigUtil() {
    }

    public static String getString(String key2, String defaultValue) {
        String normalizedKey = ConfigUtil.normalizePropertyKey(key2);
        String systemProperty = System.getProperties().entrySet().stream().filter(entry -> normalizedKey.equals(ConfigUtil.normalizePropertyKey(entry.getKey().toString()))).map(entry -> entry.getValue().toString()).findFirst().orElse(null);
        if (systemProperty != null) {
            return systemProperty;
        }
        return System.getenv().entrySet().stream().filter(entry -> normalizedKey.equals(ConfigUtil.normalizeEnvironmentVariableKey((String)entry.getKey()))).map(Map.Entry::getValue).findFirst().orElse(defaultValue);
    }

    public static String normalizeEnvironmentVariableKey(String key2) {
        return key2.toLowerCase(Locale.ROOT).replace("_", ".");
    }

    public static String normalizePropertyKey(String key2) {
        return key2.toLowerCase(Locale.ROOT).replace("-", ".");
    }

    public static <T> T defaultIfNull(@Nullable T value2, T defaultValue) {
        return value2 == null ? defaultValue : value2;
    }
}

