/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.auth;

import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import java.lang.reflect.Field;
import java.util.Map;

public interface Authenticator {
    public Map<String, String> getHeaders();

    public static void setAuthenticatorOnDelegate(Object builder, Authenticator authenticator) {
        try {
            Field field = builder.getClass().getDeclaredField("delegate");
            field.setAccessible(true);
            Object value2 = field.get(builder);
            if (value2 instanceof GrpcExporterBuilder) {
                throw new IllegalArgumentException("GrpcExporterBuilder not supported yet.");
            }
            if (!(value2 instanceof HttpExporterBuilder)) {
                throw new IllegalArgumentException("Delegate field is not type DefaultGrpcExporterBuilder or OkHttpGrpcExporterBuilder.");
            }
            ((HttpExporterBuilder)value2).setAuthenticator(authenticator);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Unable to access delegate reflectively.", e);
        }
    }
}

