/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.grpc;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterMetrics;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GrpcExporter<T extends Marshaler> {
    private static final Logger internalLogger = Logger.getLogger(GrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final GrpcSender<T> grpcSender;
    private final ExporterMetrics exporterMetrics;

    public GrpcExporter(String exporterName, String type2, GrpcSender<T> grpcSender, Supplier<MeterProvider> meterProviderSupplier) {
        this.type = type2;
        this.grpcSender = grpcSender;
        this.exporterMetrics = ExporterMetrics.createGrpc(exporterName, type2, meterProviderSupplier);
    }

    public CompletableResultCode export(T exportRequest, int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(numItems);
        CompletableResultCode result2 = new CompletableResultCode();
        this.grpcSender.send(exportRequest, () -> {
            this.exporterMetrics.addSuccess(numItems);
            result2.succeed();
        }, (response2, throwable) -> {
            this.exporterMetrics.addFailed(numItems);
            switch (response2.grpcStatusValue()) {
                case 12: {
                    if (!this.loggedUnimplemented.compareAndSet(false, true)) break;
                    GrpcExporterUtil.logUnimplemented(internalLogger, this.type, response2.grpcStatusDescription());
                    break;
                }
                case 14: {
                    this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + response2.grpcStatusDescription());
                    break;
                }
                default: {
                    this.logger.log(Level.WARNING, "Failed to export " + this.type + "s. Server responded with gRPC status code " + response2.grpcStatusValue() + ". Error message: " + response2.grpcStatusDescription());
                }
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Failed to export " + this.type + "s. Details follow: " + throwable);
            }
            result2.fail();
        });
        return result2;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.grpcSender.shutdown();
    }
}

