/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.incubator.logs.AnyValue;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.ArrayAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.BytesAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueStatelessMarshaler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public final class AnyValueStatelessMarshaler
implements StatelessMarshaler<AnyValue<?>> {
    public static final AnyValueStatelessMarshaler INSTANCE = new AnyValueStatelessMarshaler();

    private AnyValueStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, AnyValue<?> value2, MarshalerContext context) throws IOException {
        switch (value2.getType()) {
            case STRING: {
                StringAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (String)value2.getValue(), context);
                return;
            }
            case BOOLEAN: {
                BoolAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Boolean)value2.getValue(), context);
                return;
            }
            case LONG: {
                IntAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Long)value2.getValue(), context);
                return;
            }
            case DOUBLE: {
                DoubleAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Double)value2.getValue(), context);
                return;
            }
            case ARRAY: {
                output.serializeMessageWithContext(io.opentelemetry.proto.common.v1.internal.AnyValue.ARRAY_VALUE, (List)value2.getValue(), ArrayAnyValueStatelessMarshaler.INSTANCE, context);
                return;
            }
            case KEY_VALUE_LIST: {
                output.serializeMessageWithContext(io.opentelemetry.proto.common.v1.internal.AnyValue.KVLIST_VALUE, (List)value2.getValue(), KeyValueListAnyValueStatelessMarshaler.INSTANCE, context);
                return;
            }
            case BYTES: {
                BytesAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (ByteBuffer)value2.getValue(), context);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }

    @Override
    public int getBinarySerializedSize(AnyValue<?> value2, MarshalerContext context) {
        switch (value2.getType()) {
            case STRING: {
                return StringAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((String)value2.getValue(), context);
            }
            case BOOLEAN: {
                return BoolAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Boolean)value2.getValue(), context);
            }
            case LONG: {
                return IntAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Long)value2.getValue(), context);
            }
            case DOUBLE: {
                return DoubleAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Double)value2.getValue(), context);
            }
            case ARRAY: {
                return StatelessMarshalerUtil.sizeMessageWithContext(io.opentelemetry.proto.common.v1.internal.AnyValue.ARRAY_VALUE, (List)value2.getValue(), ArrayAnyValueStatelessMarshaler.INSTANCE, context);
            }
            case KEY_VALUE_LIST: {
                return StatelessMarshalerUtil.sizeMessageWithContext(io.opentelemetry.proto.common.v1.internal.AnyValue.KVLIST_VALUE, (List)value2.getValue(), KeyValueListAnyValueStatelessMarshaler.INSTANCE, context);
            }
            case BYTES: {
                return BytesAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((ByteBuffer)value2.getValue(), context);
            }
        }
        throw new IllegalArgumentException("Unsupported value type.");
    }
}

