/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import java.io.IOException;

final class BoolAnyValueMarshaler
extends MarshalerWithSize {
    private final boolean value;

    private BoolAnyValueMarshaler(boolean value2) {
        super(BoolAnyValueMarshaler.calculateSize(value2));
        this.value = value2;
    }

    static MarshalerWithSize create(boolean value2) {
        return new BoolAnyValueMarshaler(value2);
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeBool(AnyValue.BOOL_VALUE, this.value);
    }

    private static int calculateSize(boolean value2) {
        return AnyValue.BOOL_VALUE.getTagSize() + CodedOutputStream.computeBoolSizeNoTag(value2);
    }
}

