/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import java.io.IOException;
import java.nio.ByteBuffer;

final class BytesAnyValueMarshaler
extends MarshalerWithSize {
    private final byte[] value;

    private BytesAnyValueMarshaler(byte[] value2) {
        super(BytesAnyValueMarshaler.calculateSize(value2));
        this.value = value2;
    }

    static MarshalerWithSize create(ByteBuffer value2) {
        byte[] bytes = new byte[value2.remaining()];
        value2.get(bytes);
        return new BytesAnyValueMarshaler(bytes);
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeBytes(AnyValue.BYTES_VALUE, this.value);
    }

    private static int calculateSize(byte[] value2) {
        return AnyValue.BYTES_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(value2);
    }
}

