/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.logs;

import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.opentelemetry.exporter.internal.otlp.logs.LowAllocationLogsRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpLogRecordExporter
implements LogRecordExporter {
    private final Deque<LowAllocationLogsRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationLogsRequestMarshaler>();
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    private final MemoryMode memoryMode;

    OtlpHttpLogRecordExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.memoryMode = memoryMode;
    }

    public static OtlpHttpLogRecordExporter getDefault() {
        return OtlpHttpLogRecordExporter.builder().build();
    }

    public static OtlpHttpLogRecordExporterBuilder builder() {
        return new OtlpHttpLogRecordExporterBuilder();
    }

    public OtlpHttpLogRecordExporterBuilder toBuilder() {
        return new OtlpHttpLogRecordExporterBuilder(this.builder.copy(), this.memoryMode);
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationLogsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationLogsRequestMarshaler();
            }
            LowAllocationLogsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(logs);
            return this.delegate.export(exportMarshaler, logs.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        LogsRequestMarshaler request2 = LogsRequestMarshaler.create(logs);
        return this.delegate.export(request2, logs.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpLogRecordExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.memoryMode));
        return joiner.toString();
    }
}

