/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.AttributesMap;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import io.opentelemetry.sdk.logs.SdkLogRecordData;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SdkReadWriteLogRecord
implements ReadWriteLogRecord {
    private final LogLimits logLimits;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long timestampEpochNanos;
    private final long observedTimestampEpochNanos;
    private final SpanContext spanContext;
    private final Severity severity;
    @Nullable
    private final String severityText;
    private final Body body;
    private final Object lock = new Object();
    @Nullable
    private AttributesMap attributes;

    private SdkReadWriteLogRecord(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, Body body2, @Nullable AttributesMap attributes2) {
        this.logLimits = logLimits;
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.body = body2;
        this.attributes = attributes2;
    }

    static SdkReadWriteLogRecord create(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, Body body2, @Nullable AttributesMap attributes2) {
        return new SdkReadWriteLogRecord(logLimits, resource, instrumentationScopeInfo, timestampEpochNanos, observedTimestampEpochNanos, spanContext, severity, severityText, body2, attributes2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteLogRecord setAttribute(AttributeKey<T> key2, T value2) {
        if (key2 == null || key2.getKey().isEmpty() || value2 == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(key2, value2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getImmutableAttributes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return Attributes.empty();
            }
            return this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecordData toLogRecordData() {
        Object object = this.lock;
        synchronized (object) {
            return SdkLogRecordData.create(this.resource, this.instrumentationScopeInfo, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.body, this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues());
        }
    }
}

