/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleGauge;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkLongGauge;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleGauge
extends AbstractInstrument
implements DoubleGauge {
    private final WriteableMetricStorage storage;

    private SdkDoubleGauge(InstrumentDescriptor descriptor2, WriteableMetricStorage storage2) {
        super(descriptor2);
        this.storage = storage2;
    }

    @Override
    public void set(double value2, Attributes attributes2) {
        this.storage.recordDouble(value2, attributes2, Context.current());
    }

    @Override
    public void set(double value2, Attributes attributes2, Context context) {
        this.storage.recordDouble(value2, attributes2, context);
    }

    @Override
    public void set(double increment) {
        this.set(increment, Attributes.empty());
    }

    static final class SdkDoubleGaugeBuilder
    implements ExtendedDoubleGaugeBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleGaugeBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        public DoubleGaugeBuilder setDescription(String description2) {
            this.builder.setDescription(description2);
            return this;
        }

        @Override
        public DoubleGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleGauge build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleGauge((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ExtendedDoubleGaugeBuilder setAttributesAdvice(List<AttributeKey<?>> attributes2) {
            this.builder.setAdviceAttributes(attributes2);
            return this;
        }

        @Override
        public LongGaugeBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongGauge.SdkLongGaugeBuilder::new);
        }

        @Override
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback2) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback2);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

