/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleUpDownCounter
extends AbstractInstrument
implements DoubleUpDownCounter {
    private final WriteableMetricStorage storage;

    private SdkDoubleUpDownCounter(InstrumentDescriptor descriptor2, WriteableMetricStorage storage2) {
        super(descriptor2);
        this.storage = storage2;
    }

    @Override
    public void add(double increment, Attributes attributes2, Context context) {
        this.storage.recordDouble(increment, attributes2, context);
    }

    @Override
    public void add(double increment, Attributes attributes2) {
        this.add(increment, attributes2, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    static final class SdkDoubleUpDownCounterBuilder
    implements ExtendedDoubleUpDownCounterBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleUpDownCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description2, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, meterProviderSharedState, sharedState).setDescription(description2).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public DoubleUpDownCounterBuilder setDescription(String description2) {
            this.builder.setDescription(description2);
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleUpDownCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback2) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback2);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        @Override
        public ExtendedDoubleUpDownCounterBuilder setAttributesAdvice(List<AttributeKey<?>> attributes2) {
            this.builder.setAdviceAttributes(attributes2);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

