/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class SdkLongHistogram
extends AbstractInstrument
implements LongHistogram {
    private static final Logger logger = Logger.getLogger(SdkLongHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkLongHistogram(InstrumentDescriptor descriptor2, WriteableMetricStorage storage2) {
        super(descriptor2);
        this.storage = storage2;
    }

    @Override
    public void record(long value2, Attributes attributes2, Context context) {
        if (value2 < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(value2, attributes2, context);
    }

    @Override
    public void record(long value2, Attributes attributes2) {
        this.record(value2, attributes2, Context.current());
    }

    @Override
    public void record(long value2) {
        this.record(value2, Attributes.empty());
    }

    static final class SdkLongHistogramBuilder
    implements ExtendedLongHistogramBuilder {
        private final InstrumentBuilder builder;

        SdkLongHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description2, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.HISTOGRAM, InstrumentValueType.LONG, meterProviderSharedState, sharedState).setDescription(description2).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public LongHistogramBuilder setDescription(String description2) {
            this.builder.setDescription(description2);
            return this;
        }

        @Override
        public LongHistogramBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongHistogram build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1) -> new SdkLongHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ExtendedLongHistogramBuilder setExplicitBucketBoundariesAdvice(List<Long> bucketBoundaries) {
            List<Double> boundaries;
            try {
                Objects.requireNonNull(bucketBoundaries, "bucketBoundaries must not be null");
                boundaries = bucketBoundaries.stream().map(Long::doubleValue).collect(Collectors.toList());
                ExplicitBucketHistogramUtils.validateBucketBoundaries(boundaries);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warning("Error setting explicit bucket boundaries advice: " + e.getMessage());
                return this;
            }
            this.builder.setExplicitBucketBoundaries(boundaries);
            return this;
        }

        @Override
        public ExtendedLongHistogramBuilder setAttributesAdvice(List<AttributeKey<?>> attributes2) {
            this.builder.setAdviceAttributes(attributes2);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

