/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatorHandle<T extends PointData, U extends ExemplarData> {
    private final ExemplarReservoir<U> exemplarReservoir;
    private volatile boolean valuesRecorded = false;

    protected AggregatorHandle(ExemplarReservoir<U> exemplarReservoir) {
        this.exemplarReservoir = exemplarReservoir;
    }

    public final T aggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes2, boolean reset) {
        if (reset) {
            this.valuesRecorded = false;
        }
        return this.doAggregateThenMaybeReset(startEpochNanos, epochNanos, attributes2, this.exemplarReservoir.collectAndReset(attributes2), reset);
    }

    protected abstract T doAggregateThenMaybeReset(long var1, long var3, Attributes var5, List<U> var6, boolean var7);

    public final void recordLong(long value2, Attributes attributes2, Context context) {
        this.exemplarReservoir.offerLongMeasurement(value2, attributes2, context);
        this.recordLong(value2);
    }

    public final void recordLong(long value2) {
        this.doRecordLong(value2);
        this.valuesRecorded = true;
    }

    protected void doRecordLong(long value2) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    public final void recordDouble(double value2, Attributes attributes2, Context context) {
        this.exemplarReservoir.offerDoubleMeasurement(value2, attributes2, context);
        this.recordDouble(value2);
    }

    public final void recordDouble(double value2) {
        this.doRecordDouble(value2);
        this.valuesRecorded = true;
    }

    protected void doRecordDouble(double value2) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }

    public boolean hasRecordedValues() {
        return this.valuesRecorded;
    }
}

