/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.DynamicPrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleBase2ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.data.EmptyExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.MutableExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.data.MutableExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DoubleBase2ExponentialHistogramAggregator
implements Aggregator<ExponentialHistogramPointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final int maxBuckets;
    private final int maxScale;
    private final MemoryMode memoryMode;

    public DoubleBase2ExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, int maxBuckets, int maxScale, MemoryMode memoryMode) {
        this.reservoirSupplier = reservoirSupplier;
        this.maxBuckets = maxBuckets;
        this.maxScale = maxScale;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<ExponentialHistogramPointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.maxBuckets, this.maxScale, this.memoryMode);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<ExponentialHistogramPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createExponentialHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableExponentialHistogramData.create(temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<ExponentialHistogramPointData, DoubleExemplarData> {
        private final int maxBuckets;
        private final int maxScale;
        @Nullable
        private DoubleBase2ExponentialHistogramBuckets positiveBuckets;
        @Nullable
        private DoubleBase2ExponentialHistogramBuckets negativeBuckets;
        private long zeroCount;
        private double sum;
        private double min;
        private double max;
        private long count;
        private int currentScale;
        private final MemoryMode memoryMode;
        @Nullable
        private final MutableExponentialHistogramPointData reusablePoint;

        Handle(ExemplarReservoir<DoubleExemplarData> reservoir, int maxBuckets, int maxScale, MemoryMode memoryMode) {
            super(reservoir);
            this.maxBuckets = maxBuckets;
            this.maxScale = maxScale;
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            this.currentScale = maxScale;
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableExponentialHistogramPointData() : null;
            this.memoryMode = memoryMode;
        }

        @Override
        protected synchronized ExponentialHistogramPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes2, List<DoubleExemplarData> exemplars, boolean reset) {
            ExponentialHistogramPointData point = this.reusablePoint == null ? ImmutableExponentialHistogramPointData.create(this.currentScale, this.sum, this.zeroCount, this.count > 0L, this.min, this.count > 0L, this.max, this.resolveBuckets(this.positiveBuckets, this.currentScale, reset, null), this.resolveBuckets(this.negativeBuckets, this.currentScale, reset, null), startEpochNanos, epochNanos, attributes2, exemplars) : this.reusablePoint.set(this.currentScale, this.sum, this.zeroCount, this.count > 0L, this.min, this.count > 0L, this.max, this.resolveBuckets(this.positiveBuckets, this.currentScale, reset, this.reusablePoint.getPositiveBuckets()), this.resolveBuckets(this.negativeBuckets, this.currentScale, reset, this.reusablePoint.getNegativeBuckets()), startEpochNanos, epochNanos, attributes2, exemplars);
            if (reset) {
                this.sum = 0.0;
                this.zeroCount = 0L;
                this.min = Double.MAX_VALUE;
                this.max = -1.0;
                this.count = 0L;
                this.currentScale = this.maxScale;
            }
            return point;
        }

        private ExponentialHistogramBuckets resolveBuckets(@Nullable DoubleBase2ExponentialHistogramBuckets buckets, int scale, boolean reset, @Nullable ExponentialHistogramBuckets reusableBuckets) {
            ExponentialHistogramBuckets copy2;
            if (buckets == null) {
                return EmptyExponentialHistogramBuckets.get(scale);
            }
            if (reusableBuckets == null) {
                copy2 = buckets.copy();
            } else {
                MutableExponentialHistogramBuckets mutableExponentialHistogramBuckets = reusableBuckets instanceof MutableExponentialHistogramBuckets ? (MutableExponentialHistogramBuckets)reusableBuckets : new MutableExponentialHistogramBuckets();
                DynamicPrimitiveLongList reusableBucketCountsList = mutableExponentialHistogramBuckets.getReusableBucketCountsList();
                buckets.getBucketCountsIntoReusableList(reusableBucketCountsList);
                mutableExponentialHistogramBuckets.set(buckets.getScale(), buckets.getOffset(), buckets.getTotalCount(), reusableBucketCountsList);
                copy2 = mutableExponentialHistogramBuckets;
            }
            if (reset) {
                buckets.clear(this.maxScale);
            }
            return copy2;
        }

        @Override
        protected synchronized void doRecordDouble(double value2) {
            DoubleBase2ExponentialHistogramBuckets buckets;
            if (!Double.isFinite(value2)) {
                return;
            }
            this.sum += value2;
            this.min = Math.min(this.min, value2);
            this.max = Math.max(this.max, value2);
            ++this.count;
            int c = Double.compare(value2, 0.0);
            if (c == 0) {
                ++this.zeroCount;
                return;
            }
            if (c > 0) {
                if (this.positiveBuckets == null) {
                    this.positiveBuckets = new DoubleBase2ExponentialHistogramBuckets(this.currentScale, this.maxBuckets, this.memoryMode);
                }
                buckets = this.positiveBuckets;
            } else {
                if (this.negativeBuckets == null) {
                    this.negativeBuckets = new DoubleBase2ExponentialHistogramBuckets(this.currentScale, this.maxBuckets, this.memoryMode);
                }
                buckets = this.negativeBuckets;
            }
            if (!buckets.record(value2)) {
                this.downScale(buckets.getScaleReduction(value2));
                buckets.record(value2);
            }
        }

        @Override
        protected void doRecordLong(long value2) {
            this.doRecordDouble(value2);
        }

        void downScale(int by) {
            if (this.positiveBuckets != null) {
                this.positiveBuckets.downscale(by);
                this.currentScale = this.positiveBuckets.getScale();
            }
            if (this.negativeBuckets != null) {
                this.negativeBuckets.downscale(by);
                this.currentScale = this.negativeBuckets.getScale();
            }
        }
    }
}

