/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.AutoValue_ImmutableHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.HistogramPointDataValidations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableHistogramPointData
implements HistogramPointData {
    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes2, double sum, boolean hasMin, double min2, boolean hasMax, double max, List<Double> boundaries, List<Long> counts) {
        return ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes2, sum, hasMin, min2, hasMax, max, boundaries, counts, Collections.emptyList());
    }

    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes2, double sum, boolean hasMin, double min2, boolean hasMax, double max, List<Double> boundaries, List<Long> counts, List<DoubleExemplarData> exemplars) {
        if (counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException("invalid counts: size should be " + (boundaries.size() + 1) + " instead of " + counts.size());
        }
        HistogramPointDataValidations.validateIsStrictlyIncreasing(boundaries);
        HistogramPointDataValidations.validateFiniteBoundaries(boundaries);
        long totalCount = 0L;
        for (long c : PrimitiveLongList.toArray(counts)) {
            totalCount += c;
        }
        return new AutoValue_ImmutableHistogramPointData(startEpochNanos, epochNanos, attributes2, sum, totalCount, hasMin, min2, hasMax, max, Collections.unmodifiableList(new ArrayList<Double>(boundaries)), Collections.unmodifiableList(new ArrayList<Long>(counts)), exemplars);
    }

    ImmutableHistogramPointData() {
    }
}

