/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MutableLongPointData
implements LongPointData {
    private long value;
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private List<LongExemplarData> exemplars = Collections.emptyList();

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<LongExemplarData> getExemplars() {
        return this.exemplars;
    }

    public void set(LongPointData point) {
        this.set(point.getStartEpochNanos(), point.getEpochNanos(), point.getAttributes(), point.getValue(), point.getExemplars());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes2, long value2) {
        this.set(startEpochNanos, epochNanos, attributes2, value2, Collections.emptyList());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes2, long value2, List<LongExemplarData> exemplars) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes2;
        this.value = value2;
        this.exemplars = exemplars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongPointData)) {
            return false;
        }
        LongPointData that = (LongPointData)o;
        return this.value == that.getValue() && this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && Objects.equals(this.attributes, that.getAttributes()) && Objects.equals(this.exemplars, that.getExemplars());
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode *= 1000003;
        hashcode ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hashcode *= 1000003;
        hashcode ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hashcode *= 1000003;
        hashcode ^= this.attributes.hashCode();
        hashcode *= 1000003;
        hashcode ^= (int)(this.value >>> 32 ^ this.value);
        hashcode *= 1000003;
        return hashcode ^= this.exemplars.hashCode();
    }

    public String toString() {
        return "MutableLongPointData{value=" + this.value + ", startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", exemplars=" + this.exemplars + '}';
    }
}

