/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DefaultSynchronousMetricStorage<T extends PointData, U extends ExemplarData>
implements SynchronousMetricStorage {
    private static final Logger internalLogger = Logger.getLogger(DefaultSynchronousMetricStorage.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private volatile AggregatorHolder<T, U> aggregatorHolder = new AggregatorHolder();
    private final AttributesProcessor attributesProcessor;
    private final MemoryMode memoryMode;
    private final ArrayList<T> reusableResultList = new ArrayList();
    private volatile ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> previousCollectionAggregatorHandles = new ConcurrentHashMap();
    private final int maxCardinality;
    private final ConcurrentLinkedQueue<AggregatorHandle<T, U>> aggregatorHandlePool = new ConcurrentLinkedQueue();

    DefaultSynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int maxCardinality) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = maxCardinality - 1;
        this.memoryMode = registeredReader.getReader().getMemoryMode();
    }

    Queue<AggregatorHandle<T, U>> getAggregatorHandlePool() {
        return this.aggregatorHandlePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLong(long value2, Attributes attributes2, Context context) {
        AggregatorHolder<T, U> aggregatorHolder = this.getHolderForRecord();
        try {
            AggregatorHandle<T, U> handle2 = this.getAggregatorHandle(((AggregatorHolder)aggregatorHolder).aggregatorHandles, attributes2, context);
            handle2.recordLong(value2, attributes2, context);
        }
        finally {
            this.releaseHolderForRecord(aggregatorHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDouble(double value2, Attributes attributes2, Context context) {
        if (Double.isNaN(value2)) {
            this.logger.log(Level.FINE, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has recorded measurement Not-a-Number (NaN) value with attributes " + attributes2 + ". Dropping measurement.");
            return;
        }
        AggregatorHolder<T, U> aggregatorHolder = this.getHolderForRecord();
        try {
            AggregatorHandle<T, U> handle2 = this.getAggregatorHandle(((AggregatorHolder)aggregatorHolder).aggregatorHandles, attributes2, context);
            handle2.recordDouble(value2, attributes2, context);
        }
        finally {
            this.releaseHolderForRecord(aggregatorHolder);
        }
    }

    private AggregatorHolder<T, U> getHolderForRecord() {
        AggregatorHolder<T, U> aggregatorHolder;
        int recordsInProgress;
        while ((recordsInProgress = ((AggregatorHolder)(aggregatorHolder = this.aggregatorHolder)).activeRecordingThreads.addAndGet(2)) % 2 != 0) {
            ((AggregatorHolder)aggregatorHolder).activeRecordingThreads.addAndGet(-2);
        }
        return aggregatorHolder;
    }

    private void releaseHolderForRecord(AggregatorHolder<T, U> aggregatorHolder) {
        ((AggregatorHolder)aggregatorHolder).activeRecordingThreads.addAndGet(-2);
    }

    private AggregatorHandle<T, U> getAggregatorHandle(ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles, Attributes attributes2, Context context) {
        AggregatorHandle<T, U> newHandle;
        Objects.requireNonNull(attributes2, "attributes");
        attributes2 = this.attributesProcessor.process(attributes2, context);
        AggregatorHandle<T, U> handle2 = aggregatorHandles.get(attributes2);
        if (handle2 != null) {
            return handle2;
        }
        if (aggregatorHandles.size() >= this.maxCardinality) {
            this.logger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            attributes2 = MetricStorage.CARDINALITY_OVERFLOW;
            handle2 = aggregatorHandles.get(attributes2);
            if (handle2 != null) {
                return handle2;
            }
        }
        if ((newHandle = this.aggregatorHandlePool.poll()) == null) {
            newHandle = this.aggregator.createHandle();
        }
        return (handle2 = aggregatorHandles.putIfAbsent(attributes2, newHandle)) != null ? handle2 : newHandle;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        ArrayList<Object> points;
        ConcurrentHashMap aggregatorHandles;
        long start2;
        boolean reset = this.aggregationTemporality == AggregationTemporality.DELTA;
        long l = start2 = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : startEpochNanos;
        if (reset) {
            AggregatorHolder<T, U> holder = this.aggregatorHolder;
            this.aggregatorHolder = this.memoryMode == MemoryMode.REUSABLE_DATA ? new AggregatorHolder(this.previousCollectionAggregatorHandles) : new AggregatorHolder();
            int recordsInProgress = ((AggregatorHolder)holder).activeRecordingThreads.addAndGet(1);
            while (recordsInProgress > 1) {
                recordsInProgress = ((AggregatorHolder)holder).activeRecordingThreads.get();
            }
            aggregatorHandles = ((AggregatorHolder)holder).aggregatorHandles;
        } else {
            aggregatorHandles = ((AggregatorHolder)this.aggregatorHolder).aggregatorHandles;
        }
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.reusableResultList.clear();
            points = this.reusableResultList;
        } else {
            points = new ArrayList(aggregatorHandles.size());
        }
        if (this.memoryMode == MemoryMode.REUSABLE_DATA && reset && aggregatorHandles.size() >= this.maxCardinality) {
            aggregatorHandles.forEach((attribute, handle2) -> {
                if (!handle2.hasRecordedValues()) {
                    aggregatorHandles.remove(attribute);
                }
            });
        }
        aggregatorHandles.forEach((attributes2, handle2) -> {
            if (!handle2.hasRecordedValues()) {
                return;
            }
            Object point = handle2.aggregateThenMaybeReset(start2, epochNanos, (Attributes)attributes2, reset);
            if (reset && this.memoryMode == MemoryMode.IMMUTABLE_DATA) {
                this.aggregatorHandlePool.offer((AggregatorHandle<T, U>)handle2);
            }
            if (point != null) {
                points.add(point);
            }
        });
        int toDelete = this.aggregatorHandlePool.size() - (this.maxCardinality + 1);
        for (int i = 0; i < toDelete; ++i) {
            this.aggregatorHandlePool.poll();
        }
        if (reset && this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.previousCollectionAggregatorHandles = aggregatorHandles;
        }
        if (points.isEmpty()) {
            return EmptyMetricData.getInstance();
        }
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, points, this.aggregationTemporality);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    private static class AggregatorHolder<T extends PointData, U extends ExemplarData> {
        private final ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles;
        private final AtomicInteger activeRecordingThreads = new AtomicInteger(0);

        private AggregatorHolder() {
            this.aggregatorHandles = new ConcurrentHashMap();
        }

        private AggregatorHolder(ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles) {
            this.aggregatorHandles = aggregatorHandles;
        }
    }
}

