/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.ImmutableMeasurement;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;
import io.opentelemetry.sdk.metrics.internal.state.MutableMeasurement;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkObservableMeasurement
implements ObservableLongMeasurement,
ObservableDoubleMeasurement {
    private static final Logger logger = Logger.getLogger(SdkObservableMeasurement.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final InstrumentDescriptor instrumentDescriptor;
    private final List<AsynchronousMetricStorage<?, ?>> storages;
    private final MutableMeasurement mutableMeasurement = new MutableMeasurement();
    @Nullable
    private volatile RegisteredReader activeReader;
    private volatile long startEpochNanos;
    private volatile long epochNanos;

    private SdkObservableMeasurement(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> storages) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.instrumentDescriptor = instrumentDescriptor;
        this.storages = storages;
    }

    public static SdkObservableMeasurement create(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> storages) {
        return new SdkObservableMeasurement(instrumentationScopeInfo, instrumentDescriptor, storages);
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public void setActiveReader(RegisteredReader registeredReader, long startEpochNanos, long epochNanos) {
        this.activeReader = registeredReader;
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
    }

    public void unsetActiveReader() {
        this.activeReader = null;
    }

    InstrumentDescriptor getInstrumentDescriptor() {
        return this.instrumentDescriptor;
    }

    List<AsynchronousMetricStorage<?, ?>> getStorages() {
        return this.storages;
    }

    @Override
    public void record(long value2) {
        this.record(value2, Attributes.empty());
    }

    @Override
    public void record(long value2, Attributes attributes2) {
        Measurement measurement;
        if (this.activeReader == null) {
            this.logNoActiveReader();
            return;
        }
        MemoryMode memoryMode = this.activeReader.getReader().getMemoryMode();
        if (Objects.requireNonNull(memoryMode) == MemoryMode.IMMUTABLE_DATA) {
            measurement = ImmutableMeasurement.createLong(this.startEpochNanos, this.epochNanos, value2, attributes2);
        } else {
            MutableMeasurement.setLongMeasurement(this.mutableMeasurement, this.startEpochNanos, this.epochNanos, value2, attributes2);
            measurement = this.mutableMeasurement;
        }
        this.doRecord(measurement);
    }

    @Override
    public void record(double value2) {
        this.record(value2, Attributes.empty());
    }

    @Override
    public void record(double value2, Attributes attributes2) {
        Measurement measurement;
        if (this.activeReader == null) {
            this.logNoActiveReader();
            return;
        }
        if (Double.isNaN(value2)) {
            logger.log(Level.FINE, "Instrument " + this.instrumentDescriptor.getName() + " has recorded measurement Not-a-Number (NaN) value with attributes " + attributes2 + ". Dropping measurement.");
            return;
        }
        MemoryMode memoryMode = this.activeReader.getReader().getMemoryMode();
        if (Objects.requireNonNull(memoryMode) == MemoryMode.IMMUTABLE_DATA) {
            measurement = ImmutableMeasurement.createDouble(this.startEpochNanos, this.epochNanos, value2, attributes2);
        } else {
            MutableMeasurement.setDoubleMeasurement(this.mutableMeasurement, this.startEpochNanos, this.epochNanos, value2, attributes2);
            measurement = this.mutableMeasurement;
        }
        this.doRecord(measurement);
    }

    private void doRecord(Measurement measurement) {
        RegisteredReader activeReader = this.activeReader;
        for (AsynchronousMetricStorage<?, ?> storage2 : this.storages) {
            if (!storage2.getRegisteredReader().equals(activeReader)) continue;
            storage2.record(measurement);
        }
    }

    private void logNoActiveReader() {
        this.throttlingLogger.log(Level.FINE, "Measurement recorded for instrument " + this.instrumentDescriptor.getName() + " outside callback registered to instrument. Dropping measurement.");
    }
}

