/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.ImmutableEventData;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface EventData {
    public static EventData create(long epochNanos, String name, Attributes attributes2) {
        return ImmutableEventData.create(epochNanos, name, attributes2);
    }

    public static EventData create(long epochNanos, String name, Attributes attributes2, int totalAttributeCount) {
        return ImmutableEventData.create(epochNanos, name, attributes2, totalAttributeCount);
    }

    public String getName();

    public Attributes getAttributes();

    public long getEpochNanos();

    public int getTotalAttributeCount();

    default public int getDroppedAttributesCount() {
        return this.getTotalAttributeCount() - this.getAttributes().size();
    }
}

