/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.AbstractCharDataConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;

public abstract class AbstractCharResponseConsumer<T>
extends AbstractCharDataConsumer
implements AsyncResponseConsumer<T> {
    private volatile FutureCallback<T> resultCallback;
    private final Charset defaultCharset;

    public AbstractCharResponseConsumer() {
        this.defaultCharset = StandardCharsets.UTF_8;
    }

    protected AbstractCharResponseConsumer(int bufSize, CharCodingConfig charCodingConfig) {
        super(bufSize, charCodingConfig);
        this.defaultCharset = charCodingConfig != null && charCodingConfig.getCharset() != null ? charCodingConfig.getCharset() : StandardCharsets.UTF_8;
    }

    protected abstract void start(HttpResponse var1, ContentType var2) throws HttpException, IOException;

    protected abstract T buildResult() throws IOException;

    @Override
    public void informationResponse(HttpResponse response2, HttpContext context) throws HttpException, IOException {
    }

    @Override
    public final void consumeResponse(HttpResponse response2, EntityDetails entityDetails, HttpContext context, FutureCallback<T> resultCallback) throws HttpException, IOException {
        this.resultCallback = resultCallback;
        if (entityDetails != null) {
            Charset charset;
            ContentType contentType2;
            try {
                contentType2 = ContentType.parse(entityDetails.getContentType());
            }
            catch (UnsupportedCharsetException ex) {
                throw new UnsupportedEncodingException(ex.getMessage());
            }
            Charset charset2 = charset = contentType2 != null ? contentType2.getCharset() : null;
            if (charset == null) {
                charset = this.defaultCharset;
            }
            this.setCharset(charset);
            this.start(response2, contentType2 != null ? contentType2 : ContentType.DEFAULT_TEXT);
        } else {
            this.start(response2, null);
            this.completed();
        }
    }

    @Override
    protected final void completed() throws IOException {
        this.resultCallback.completed(this.buildResult());
    }

    @Override
    public void failed(Exception cause) {
    }
}

