/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;

abstract class AbstractMultipartFormat {
    private String preamble;
    private String epilogue;
    static final ByteArrayBuffer FIELD_SEP = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, ": ");
    static final ByteArrayBuffer CR_LF = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, "\r\n");
    static final ByteArrayBuffer TWO_HYPHENS = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, "--");
    final Charset charset;
    final String boundary;

    static ByteArrayBuffer encode(Charset charset, CharSequence string) {
        ByteBuffer encoded = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer bab = new ByteArrayBuffer(encoded.remaining());
        bab.append(encoded.array(), encoded.arrayOffset() + encoded.position(), encoded.remaining());
        return bab;
    }

    static void writeBytes(ByteArrayBuffer b, OutputStream out2) throws IOException {
        out2.write(b.array(), 0, b.length());
    }

    static void writeBytes(CharSequence s2, Charset charset, OutputStream out2) throws IOException {
        ByteArrayBuffer b = AbstractMultipartFormat.encode(charset, s2);
        AbstractMultipartFormat.writeBytes(b, out2);
    }

    static void writeBytes(CharSequence s2, OutputStream out2) throws IOException {
        ByteArrayBuffer b = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, s2);
        AbstractMultipartFormat.writeBytes(b, out2);
    }

    static boolean isLineBreak(char ch) {
        return ch == '\r' || ch == '\n' || ch == '\f' || ch == '\u000b';
    }

    static CharSequence stripLineBreaks(CharSequence s2) {
        int n;
        if (s2 == null) {
            return null;
        }
        boolean requiresRewrite = false;
        for (n = 0; n < s2.length(); ++n) {
            char ch = s2.charAt(n);
            if (!AbstractMultipartFormat.isLineBreak(ch)) continue;
            requiresRewrite = true;
            break;
        }
        if (!requiresRewrite) {
            return s2;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(s2, 0, n);
        while (n < s2.length()) {
            char ch = s2.charAt(n);
            if (AbstractMultipartFormat.isLineBreak(ch)) {
                buf.append(' ');
            } else {
                buf.append(ch);
            }
            ++n;
        }
        return buf.toString();
    }

    static void writeField(MimeField field, OutputStream out2) throws IOException {
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(field.getName()), out2);
        AbstractMultipartFormat.writeBytes(FIELD_SEP, out2);
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(field.getBody()), out2);
        AbstractMultipartFormat.writeBytes(CR_LF, out2);
    }

    static void writeField(MimeField field, Charset charset, OutputStream out2) throws IOException {
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(field.getName()), charset, out2);
        AbstractMultipartFormat.writeBytes(FIELD_SEP, out2);
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(field.getBody()), charset, out2);
        AbstractMultipartFormat.writeBytes(CR_LF, out2);
    }

    public AbstractMultipartFormat(Charset charset, String boundary) {
        Args.notNull(boundary, "Multipart boundary");
        this.charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
        this.boundary = boundary;
    }

    public AbstractMultipartFormat(Charset charset, String boundary, String preamble, String epilogue) {
        Args.notNull(boundary, "Multipart boundary");
        this.charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
        this.boundary = boundary;
        this.preamble = preamble;
        this.epilogue = epilogue;
    }

    public AbstractMultipartFormat(String boundary) {
        this(null, boundary);
    }

    public abstract List<MultipartPart> getParts();

    void doWriteTo(OutputStream out2, boolean writeContent) throws IOException {
        ByteArrayBuffer boundaryEncoded = AbstractMultipartFormat.encode(this.charset, this.boundary);
        if (this.preamble != null) {
            AbstractMultipartFormat.writeBytes(this.preamble, out2);
            AbstractMultipartFormat.writeBytes(CR_LF, out2);
        }
        for (MultipartPart part2 : this.getParts()) {
            AbstractMultipartFormat.writeBytes(TWO_HYPHENS, out2);
            AbstractMultipartFormat.writeBytes(boundaryEncoded, out2);
            AbstractMultipartFormat.writeBytes(CR_LF, out2);
            this.formatMultipartHeader(part2, out2);
            AbstractMultipartFormat.writeBytes(CR_LF, out2);
            if (writeContent) {
                part2.getBody().writeTo(out2);
            }
            AbstractMultipartFormat.writeBytes(CR_LF, out2);
        }
        AbstractMultipartFormat.writeBytes(TWO_HYPHENS, out2);
        AbstractMultipartFormat.writeBytes(boundaryEncoded, out2);
        AbstractMultipartFormat.writeBytes(TWO_HYPHENS, out2);
        AbstractMultipartFormat.writeBytes(CR_LF, out2);
        if (this.epilogue != null) {
            AbstractMultipartFormat.writeBytes(this.epilogue, out2);
            AbstractMultipartFormat.writeBytes(CR_LF, out2);
        }
    }

    protected abstract void formatMultipartHeader(MultipartPart var1, OutputStream var2) throws IOException;

    public void writeTo(OutputStream out2) throws IOException {
        this.doWriteTo(out2, true);
    }

    public long getTotalLength() {
        long contentLen = 0L;
        for (MultipartPart part2 : this.getParts()) {
            ContentBody body2 = part2.getBody();
            long len = body2.getContentLength();
            if (len >= 0L) {
                contentLen += len;
                continue;
            }
            return -1L;
        }
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        try {
            this.doWriteTo(out2, false);
            byte[] extra = out2.toByteArray();
            return contentLen + (long)extra.length;
        }
        catch (IOException ex) {
            return -1L;
        }
    }
}

