/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.RequestSupport;
import org.apache.hc.client5.http.impl.auth.AuthCacheKeeper;
import org.apache.hc.client5.http.impl.auth.HttpAuthenticator;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class AsyncProtocolExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncProtocolExec.class);
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final SchemePortResolver schemePortResolver;
    private final AuthCacheKeeper authCacheKeeper;

    AsyncProtocolExec(AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, SchemePortResolver schemePortResolver, boolean authCachingDisabled) {
        this.targetAuthStrategy = Args.notNull(targetAuthStrategy, "Target authentication strategy");
        this.proxyAuthStrategy = Args.notNull(proxyAuthStrategy, "Proxy authentication strategy");
        this.authenticator = new HttpAuthenticator();
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.authCacheKeeper = authCachingDisabled ? null : new AuthCacheKeeper(this.schemePortResolver);
    }

    @Override
    public void execute(HttpRequest userRequest, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope2, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        AuthExchange proxyAuthExchange;
        URIAuthority authority;
        HttpRequest request2;
        if (Method.CONNECT.isSame(userRequest.getMethod())) {
            throw new ProtocolException("Direct execution of CONNECT is not allowed");
        }
        HttpRoute route = scope2.route;
        HttpHost routeTarget = route.getTargetHost();
        HttpHost proxy = route.getProxyHost();
        HttpClientContext clientContext = scope2.clientContext;
        if (proxy != null && !route.isTunnelled()) {
            BasicRequestBuilder requestBuilder = BasicRequestBuilder.copy(userRequest);
            if (requestBuilder.getAuthority() == null) {
                requestBuilder.setAuthority(new URIAuthority(routeTarget));
            }
            requestBuilder.setAbsoluteRequestUri(true);
            request2 = requestBuilder.build();
        } else {
            request2 = userRequest;
        }
        if (request2.getScheme() == null) {
            request2.setScheme(routeTarget.getSchemeName());
        }
        if (request2.getAuthority() == null) {
            request2.setAuthority(new URIAuthority(routeTarget));
        }
        if ((authority = request2.getAuthority()).getUserInfo() != null) {
            throw new ProtocolException("Request URI authority contains deprecated userinfo component");
        }
        HttpHost target = new HttpHost(request2.getScheme(), authority.getHostName(), this.schemePortResolver.resolve(request2.getScheme(), authority));
        String pathPrefix = RequestSupport.extractPathPrefix(request2);
        AuthExchange targetAuthExchange = clientContext.getAuthExchange(target);
        AuthExchange authExchange = proxyAuthExchange = proxy != null ? clientContext.getAuthExchange(proxy) : new AuthExchange();
        if (!targetAuthExchange.isConnectionBased() && targetAuthExchange.getPathPrefix() != null && !pathPrefix.startsWith(targetAuthExchange.getPathPrefix())) {
            targetAuthExchange.reset();
        }
        if (targetAuthExchange.getPathPrefix() == null) {
            targetAuthExchange.setPathPrefix(pathPrefix);
        }
        if (this.authCacheKeeper != null) {
            this.authCacheKeeper.loadPreemptively(target, pathPrefix, targetAuthExchange, clientContext);
            if (proxy != null) {
                this.authCacheKeeper.loadPreemptively(proxy, null, proxyAuthExchange, clientContext);
            }
        }
        AtomicBoolean challenged = new AtomicBoolean(false);
        this.internalExecute(target, pathPrefix, targetAuthExchange, proxyAuthExchange, challenged, request2, entityProducer, scope2, chain, asyncExecCallback);
    }

    private void internalExecute(final HttpHost target, final String pathPrefix, final AuthExchange targetAuthExchange, final AuthExchange proxyAuthExchange, final AtomicBoolean challenged, final HttpRequest request2, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope2, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        final String exchangeId = scope2.exchangeId;
        HttpRoute route = scope2.route;
        final HttpClientContext clientContext = scope2.clientContext;
        final AsyncExecRuntime execRuntime = scope2.execRuntime;
        final HttpHost proxy = route.getProxyHost();
        if (!request2.containsHeader("Authorization")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} target auth state: {}", (Object)exchangeId, (Object)targetAuthExchange.getState());
            }
            this.authenticator.addAuthResponse(target, ChallengeType.TARGET, request2, targetAuthExchange, clientContext);
        }
        if (!request2.containsHeader("Proxy-Authorization") && !route.isTunnelled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} proxy auth state: {}", (Object)exchangeId, (Object)proxyAuthExchange.getState());
            }
            this.authenticator.addAuthResponse(proxy, ChallengeType.PROXY, request2, proxyAuthExchange, clientContext);
        }
        chain.proceed(request2, entityProducer, scope2, new AsyncExecCallback(){

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response2, EntityDetails entityDetails) throws HttpException, IOException {
                if (Method.TRACE.isSame(request2.getMethod())) {
                    return asyncExecCallback.handleResponse(response2, entityDetails);
                }
                if (AsyncProtocolExec.this.needAuthentication(targetAuthExchange, proxyAuthExchange, proxy != null ? proxy : target, target, pathPrefix, response2, clientContext)) {
                    challenged.set(true);
                    return null;
                }
                challenged.set(false);
                return asyncExecCallback.handleResponse(response2, entityDetails);
            }

            @Override
            public void handleInformationResponse(HttpResponse response2) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response2);
            }

            @Override
            public void completed() {
                if (!execRuntime.isEndpointConnected()) {
                    if (proxyAuthExchange.getState() == AuthExchange.State.SUCCESS && proxyAuthExchange.isConnectionBased()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} resetting proxy auth state", (Object)exchangeId);
                        }
                        proxyAuthExchange.reset();
                    }
                    if (targetAuthExchange.getState() == AuthExchange.State.SUCCESS && targetAuthExchange.isConnectionBased()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} resetting target auth state", (Object)exchangeId);
                        }
                        targetAuthExchange.reset();
                    }
                }
                if (challenged.get()) {
                    if (entityProducer != null && !entityProducer.isRepeatable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                        }
                        asyncExecCallback.completed();
                    } else {
                        HttpRequest original = scope2.originalRequest;
                        request2.setHeaders(new Header[0]);
                        Iterator<Header> it = original.headerIterator();
                        while (it.hasNext()) {
                            request2.addHeader(it.next());
                        }
                        try {
                            if (entityProducer != null) {
                                entityProducer.releaseResources();
                            }
                            AsyncProtocolExec.this.internalExecute(target, pathPrefix, targetAuthExchange, proxyAuthExchange, challenged, request2, entityProducer, scope2, chain, asyncExecCallback);
                        }
                        catch (IOException | HttpException ex) {
                            asyncExecCallback.failed(ex);
                        }
                    }
                } else {
                    asyncExecCallback.completed();
                }
            }

            @Override
            public void failed(Exception cause) {
                if (cause instanceof IOException || cause instanceof RuntimeException) {
                    for (AuthExchange authExchange : clientContext.getAuthExchanges().values()) {
                        if (!authExchange.isConnectionBased()) continue;
                        authExchange.reset();
                    }
                }
                asyncExecCallback.failed(cause);
            }
        });
    }

    private boolean needAuthentication(AuthExchange targetAuthExchange, AuthExchange proxyAuthExchange, HttpHost proxy, HttpHost target, String pathPrefix, HttpResponse response2, HttpClientContext context) {
        RequestConfig config2 = context.getRequestConfig();
        if (config2.isAuthenticationEnabled()) {
            boolean targetAuthRequested = this.authenticator.isChallenged(target, ChallengeType.TARGET, response2, targetAuthExchange, context);
            if (this.authCacheKeeper != null) {
                if (targetAuthRequested) {
                    this.authCacheKeeper.updateOnChallenge(target, pathPrefix, targetAuthExchange, context);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(target, pathPrefix, targetAuthExchange, context);
                }
            }
            boolean proxyAuthRequested = this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response2, proxyAuthExchange, context);
            if (this.authCacheKeeper != null) {
                if (proxyAuthRequested) {
                    this.authCacheKeeper.updateOnChallenge(proxy, null, proxyAuthExchange, context);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(proxy, null, proxyAuthExchange, context);
                }
            }
            if (targetAuthRequested) {
                boolean updated = this.authenticator.updateAuthState(target, ChallengeType.TARGET, response2, this.targetAuthStrategy, targetAuthExchange, context);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(target, pathPrefix, targetAuthExchange, context);
                }
                return updated;
            }
            if (proxyAuthRequested) {
                boolean updated = this.authenticator.updateAuthState(proxy, ChallengeType.PROXY, response2, this.proxyAuthStrategy, proxyAuthExchange, context);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(proxy, null, proxyAuthExchange, context);
                }
                return updated;
            }
        }
        return false;
    }
}

