/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class MainClientExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MainClientExec.class);
    private final HttpClientConnectionManager connectionManager;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;

    public MainClientExec(HttpClientConnectionManager connectionManager, HttpProcessor httpProcessor, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.connectionManager = Args.notNull(connectionManager, "Connection manager");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP protocol processor");
        this.reuseStrategy = Args.notNull(reuseStrategy, "Connection reuse strategy");
        this.keepAliveStrategy = Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.userTokenHandler = Args.notNull(userTokenHandler, "User token handler");
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request2, ExecChain.Scope scope2, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(scope2, "Scope");
        String exchangeId = scope2.exchangeId;
        HttpRoute route = scope2.route;
        HttpClientContext context = scope2.clientContext;
        ExecRuntime execRuntime = scope2.execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} executing {}", (Object)exchangeId, (Object)new RequestLine(request2));
        }
        try {
            context.setAttribute("http.route", route);
            context.setAttribute("http.request", request2);
            this.httpProcessor.process(request2, (EntityDetails)request2.getEntity(), (HttpContext)context);
            ClassicHttpResponse response2 = execRuntime.execute(exchangeId, request2, context);
            context.setAttribute("http.response", response2);
            this.httpProcessor.process(response2, (EntityDetails)response2.getEntity(), (HttpContext)context);
            Object userToken = context.getUserToken();
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(route, request2, context);
                context.setAttribute("http.user-token", userToken);
            }
            if (this.reuseStrategy.keepAlive(request2, response2, context)) {
                TimeValue duration = this.keepAliveStrategy.getKeepAliveDuration(response2, context);
                if (LOG.isDebugEnabled()) {
                    String s2 = duration != null ? "for " + duration : "indefinitely";
                    LOG.debug("{} connection can be kept alive {}", (Object)exchangeId, (Object)s2);
                }
                execRuntime.markConnectionReusable(userToken, duration);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response2.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response2, null);
            }
            return new CloseableHttpResponse(response2, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connectionManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }
}

