/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.config;

import org.apache.hc.core5.util.Args;

public class NamedElementChain<E> {
    private final Node master = new Node("master", null);
    private int size;

    public NamedElementChain() {
        this.master.previous = this.master;
        this.master.next = this.master;
        this.size = 0;
    }

    public Node getFirst() {
        return this.master.next != this.master ? this.master.next : null;
    }

    public Node getLast() {
        return this.master.previous != this.master ? this.master.previous : null;
    }

    public Node addFirst(E value2, String name) {
        Args.notBlank(name, "Name");
        Args.notNull(value2, "Value");
        Node newNode = new Node(name, value2);
        Node oldNode = this.master.next;
        this.master.next = newNode;
        newNode.previous = this.master;
        newNode.next = oldNode;
        oldNode.previous = newNode;
        ++this.size;
        return newNode;
    }

    public Node addLast(E value2, String name) {
        Args.notBlank(name, "Name");
        Args.notNull(value2, "Value");
        Node newNode = new Node(name, value2);
        Node oldNode = this.master.previous;
        this.master.previous = newNode;
        newNode.previous = oldNode;
        newNode.next = this.master;
        oldNode.next = newNode;
        ++this.size;
        return newNode;
    }

    public Node find(String name) {
        Args.notBlank(name, "Name");
        return this.doFind(name);
    }

    private Node doFind(String name) {
        Node current = this.master.next;
        while (current != this.master) {
            if (name.equals(current.name)) {
                return current;
            }
            current = current.next;
        }
        return null;
    }

    public Node addBefore(String existing, E value2, String name) {
        Args.notBlank(name, "Name");
        Args.notNull(value2, "Value");
        Node current = this.doFind(existing);
        if (current == null) {
            return null;
        }
        Node newNode = new Node(name, value2);
        Node previousNode = current.previous;
        previousNode.next = newNode;
        newNode.previous = previousNode;
        newNode.next = current;
        current.previous = newNode;
        ++this.size;
        return newNode;
    }

    public Node addAfter(String existing, E value2, String name) {
        Args.notBlank(name, "Name");
        Args.notNull(value2, "Value");
        Node current = this.doFind(existing);
        if (current == null) {
            return null;
        }
        Node newNode = new Node(name, value2);
        Node nextNode = current.next;
        current.next = newNode;
        newNode.previous = current;
        newNode.next = nextNode;
        nextNode.previous = newNode;
        ++this.size;
        return newNode;
    }

    public boolean remove(String name) {
        Node node2 = this.doFind(name);
        if (node2 == null) {
            return false;
        }
        node2.previous.next = node2.next;
        node2.next.previous = node2.previous;
        node2.previous = null;
        node2.next = null;
        --this.size;
        return true;
    }

    public boolean replace(String existing, E value2) {
        Node node2 = this.doFind(existing);
        if (node2 == null) {
            return false;
        }
        node2.value = value2;
        return true;
    }

    public int getSize() {
        return this.size;
    }

    public class Node {
        private final String name;
        private E value;
        private Node previous;
        private Node next;

        Node(String name, E value2) {
            this.name = name;
            this.value = value2;
        }

        public String getName() {
            return this.name;
        }

        public E getValue() {
            return this.value;
        }

        public Node getPrevious() {
            return this.previous != NamedElementChain.this.master ? this.previous : null;
        }

        public Node getNext() {
            return this.next != NamedElementChain.this.master ? this.next : null;
        }

        public String toString() {
            return this.name + ": " + this.value;
        }
    }
}

