/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.Iterator;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicTokenIterator;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpRequest request2, HttpResponse response2, HttpContext context) {
        ProtocolVersion ver;
        Iterator<Header> headerIterator;
        Header teh;
        Args.notNull(response2, "HTTP response");
        if (request2 != null) {
            BasicTokenIterator ti = new BasicTokenIterator(request2.headerIterator("Connection"));
            while (ti.hasNext()) {
                String token2 = (String)ti.next();
                if (!"close".equalsIgnoreCase(token2)) continue;
                return false;
            }
        }
        if (response2.getCode() == 204) {
            Header clh = response2.getFirstHeader("Content-Length");
            if (clh != null) {
                try {
                    long contentLen = Long.parseLong(clh.getValue());
                    if (contentLen > 0L) {
                        return false;
                    }
                }
                catch (NumberFormatException contentLen) {
                    // empty catch block
                }
            }
            if (response2.containsHeader("Transfer-Encoding")) {
                return false;
            }
        }
        if ((teh = response2.getFirstHeader("Transfer-Encoding")) != null) {
            if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                return false;
            }
        } else {
            String method;
            String string = method = request2 != null ? request2.getMethod() : null;
            if (MessageSupport.canResponseHaveBody(method, response2) && response2.countHeaders("Content-Length") != 1) {
                return false;
            }
        }
        if (!(headerIterator = response2.headerIterator("Connection")).hasNext()) {
            headerIterator = response2.headerIterator("Proxy-Connection");
        }
        ProtocolVersion protocolVersion = ver = response2.getVersion() != null ? response2.getVersion() : context.getProtocolVersion();
        if (headerIterator.hasNext()) {
            if (ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                BasicTokenIterator it = new BasicTokenIterator(headerIterator);
                while (it.hasNext()) {
                    String token3 = (String)it.next();
                    if (!"close".equalsIgnoreCase(token3)) continue;
                    return false;
                }
                return true;
            }
            BasicTokenIterator it = new BasicTokenIterator(headerIterator);
            while (it.hasNext()) {
                String token4 = (String)it.next();
                if (!"keep-alive".equalsIgnoreCase(token4)) continue;
                return true;
            }
            return false;
        }
        return ver.greaterEquals(HttpVersion.HTTP_1_1);
    }
}

