/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducerWrapper;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.apache.hc.core5.http.nio.entity.PathEntityProducer;
import org.apache.hc.core5.net.WWWFormCodec;

public final class AsyncEntityProducers {
    private AsyncEntityProducers() {
    }

    public static AsyncEntityProducer create(String content2, ContentType contentType2) {
        return new BasicAsyncEntityProducer(content2, contentType2);
    }

    public static AsyncEntityProducer create(String content2, Charset charset) {
        return new BasicAsyncEntityProducer(content2, ContentType.TEXT_PLAIN.withCharset(charset));
    }

    public static AsyncEntityProducer create(String content2) {
        return new BasicAsyncEntityProducer(content2, ContentType.TEXT_PLAIN);
    }

    public static AsyncEntityProducer create(byte[] content2, ContentType contentType2) {
        return new BasicAsyncEntityProducer(content2, contentType2);
    }

    public static AsyncEntityProducer create(File content2, ContentType contentType2) {
        return new FileEntityProducer(content2, contentType2);
    }

    public static AsyncEntityProducer createUrlEncoded(Iterable<? extends NameValuePair> parameters2, Charset charset) {
        ContentType contentType2 = charset != null ? ContentType.APPLICATION_FORM_URLENCODED.withCharset(charset) : ContentType.APPLICATION_FORM_URLENCODED;
        return AsyncEntityProducers.create(WWWFormCodec.format(parameters2, contentType2.getCharset()), contentType2);
    }

    public static AsyncEntityProducer createBinary(final Callback<StreamChannel<ByteBuffer>> callback2, ContentType contentType2) {
        return new AbstractBinAsyncEntityProducer(0, contentType2){

            @Override
            protected int availableData() {
                return Integer.MAX_VALUE;
            }

            @Override
            protected void produceData(StreamChannel<ByteBuffer> channel2) throws IOException {
                callback2.execute(channel2);
            }

            @Override
            public boolean isRepeatable() {
                return false;
            }

            @Override
            public void failed(Exception cause) {
            }
        };
    }

    public static AsyncEntityProducer createText(final Callback<StreamChannel<CharBuffer>> callback2, ContentType contentType2) {
        return new AbstractCharAsyncEntityProducer(4096, 2048, contentType2){

            @Override
            protected int availableData() {
                return Integer.MAX_VALUE;
            }

            @Override
            protected void produceData(StreamChannel<CharBuffer> channel2) throws IOException {
                callback2.execute(channel2);
            }

            @Override
            public boolean isRepeatable() {
                return false;
            }

            @Override
            public void failed(Exception cause) {
            }
        };
    }

    public static AsyncEntityProducer withTrailers(AsyncEntityProducer entity, final Header ... trailers) {
        return new AsyncEntityProducerWrapper(entity){

            @Override
            public boolean isChunked() {
                return true;
            }

            @Override
            public long getContentLength() {
                return -1L;
            }

            @Override
            public Set<String> getTrailerNames() {
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                for (Header trailer : trailers) {
                    names.add(trailer.getName());
                }
                return names;
            }

            @Override
            public void produce(final DataStreamChannel channel2) throws IOException {
                super.produce(new DataStreamChannel(){

                    @Override
                    public void requestOutput() {
                        channel2.requestOutput();
                    }

                    @Override
                    public int write(ByteBuffer src) throws IOException {
                        return channel2.write(src);
                    }

                    @Override
                    public void endStream(List<? extends Header> p) throws IOException {
                        List<Header> allTrailers;
                        if (p != null && !p.isEmpty()) {
                            allTrailers = new ArrayList<Header>(p);
                            allTrailers.addAll(Arrays.asList(trailers));
                        } else {
                            allTrailers = Arrays.asList(trailers);
                        }
                        channel2.endStream(allTrailers);
                    }

                    @Override
                    public void endStream() throws IOException {
                        channel2.endStream();
                    }
                });
            }
        };
    }

    public static AsyncEntityProducer create(String content2, ContentType contentType2, Header ... trailers) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(content2, contentType2), trailers);
    }

    public static AsyncEntityProducer create(String content2, Charset charset, Header ... trailers) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(content2, charset), trailers);
    }

    public static AsyncEntityProducer create(String content2, Header ... trailers) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(content2), trailers);
    }

    public static AsyncEntityProducer create(byte[] content2, ContentType contentType2, Header ... trailers) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(content2, contentType2), trailers);
    }

    public static AsyncEntityProducer create(File content2, ContentType contentType2, Header ... trailers) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(content2, contentType2), trailers);
    }

    public static AsyncEntityProducer create(Path content2, ContentType contentType2, Header ... trailers) throws IOException {
        return AsyncEntityProducers.withTrailers(new PathEntityProducer(content2, contentType2, StandardOpenOption.READ), trailers);
    }

    public static AsyncEntityProducer create(Path content2, ContentType contentType2, OpenOption ... options2) throws IOException {
        return new PathEntityProducer(content2, contentType2, options2);
    }

    public static AsyncEntityProducer createBinary(Callback<StreamChannel<ByteBuffer>> callback2, ContentType contentType2, Header ... trailers) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.createBinary(callback2, contentType2), trailers);
    }

    public static AsyncEntityProducer createText(Callback<StreamChannel<CharBuffer>> callback2, ContentType contentType2, Header ... trailers) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.createText(callback2, contentType2), trailers);
    }
}

