/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response2, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response2, "HTTP response");
        Args.notNull(context, "HTTP context");
        int status = response2.getCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response2.setHeader("Connection", "close");
            return;
        }
        if (!response2.containsHeader("Connection")) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity != null && entity.getContentLength() < 0L && ver.lessEquals(HttpVersion.HTTP_1_0)) {
                response2.setHeader("Connection", "close");
            } else {
                HttpCoreContext coreContext = HttpCoreContext.adapt(context);
                HttpRequest request2 = coreContext.getRequest();
                boolean closeRequested = false;
                boolean keepAliveRequested = false;
                if (request2 != null) {
                    Iterator<HeaderElement> it = MessageSupport.iterate(request2, "Connection");
                    while (it.hasNext()) {
                        HeaderElement he = it.next();
                        if (he.getName().equalsIgnoreCase("close")) {
                            closeRequested = true;
                            break;
                        }
                        if (!he.getName().equalsIgnoreCase("keep-alive")) continue;
                        keepAliveRequested = true;
                    }
                }
                if (closeRequested) {
                    response2.addHeader("Connection", "close");
                } else if (response2.containsHeader("Upgrade")) {
                    response2.addHeader("Connection", "upgrade");
                } else if (keepAliveRequested) {
                    response2.addHeader("Connection", "keep-alive");
                } else if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    response2.addHeader("Connection", "close");
                }
            }
        }
    }
}

