/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback2) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)HttpClientContext.create(), callback2);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request2, HttpContext context, FutureCallback<HttpResponse> callback2) {
        return this.execute(HttpAsyncMethods.create(target, request2), HttpAsyncMethods.createConsumer(), context, callback2);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request2, FutureCallback<HttpResponse> callback2) {
        return this.execute(target, request2, (HttpContext)HttpClientContext.create(), callback2);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request2, FutureCallback<HttpResponse> callback2) {
        return this.execute(request2, HttpClientContext.create(), callback2);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request2, HttpContext context, FutureCallback<HttpResponse> callback2) {
        HttpHost target;
        try {
            target = this.determineTarget(request2);
        }
        catch (ClientProtocolException ex) {
            BasicFuture<HttpResponse> future = new BasicFuture<HttpResponse>(callback2);
            future.failed(ex);
            return future;
        }
        return this.execute(target, request2, context, callback2);
    }

    private HttpHost determineTarget(HttpUriRequest request2) throws ClientProtocolException {
        Args.notNull(request2, "HTTP request");
        HttpHost target = null;
        URI requestURI = request2.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

