/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.arbiters;

import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="EnvironmentArbiter", category="Core", elementType="Arbiter", deferChildren=true, printObject=true)
public class EnvironmentArbiter
implements Arbiter {
    private final String propertyName;
    private final String propertyValue;

    private EnvironmentArbiter(String propertyName, String propertyValue) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    @Override
    public boolean isCondition() {
        String value2 = System.getenv(this.propertyName);
        return value2 != null && (this.propertyValue == null || value2.equals(this.propertyValue));
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<EnvironmentArbiter> {
        public static final String ATTR_PROPERTY_NAME = "propertyName";
        public static final String ATTR_PROPERTY_VALUE = "propertyValue";
        @PluginBuilderAttribute(value="propertyName")
        private String propertyName;
        @PluginBuilderAttribute(value="propertyValue")
        private String propertyValue;

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this.asBuilder();
        }

        public Builder setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
            return this.asBuilder();
        }

        public Builder asBuilder() {
            return this;
        }

        @Override
        public EnvironmentArbiter build() {
            return new EnvironmentArbiter(this.propertyName, this.propertyValue);
        }
    }
}

