/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.util.Strings;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    public Map<String, PluginEntry> getCategory(String category) {
        String key2 = Strings.toRootLowerCase(category);
        return this.categories.computeIfAbsent(key2, ignored -> new TreeMap());
    }

    public void writeCache(OutputStream os) throws IOException {
        try (DataOutputStream out2 = new DataOutputStream(new BufferedOutputStream(os));){
            out2.writeInt(this.categories.size());
            for (Map.Entry<String, Map<String, PluginEntry>> category : this.categories.entrySet()) {
                out2.writeUTF(category.getKey());
                Map<String, PluginEntry> m4 = category.getValue();
                out2.writeInt(m4.size());
                for (Map.Entry<String, PluginEntry> entry : m4.entrySet()) {
                    PluginEntry plugin = entry.getValue();
                    out2.writeUTF(plugin.getKey());
                    out2.writeUTF(plugin.getClassName());
                    out2.writeUTF(plugin.getName());
                    out2.writeBoolean(plugin.isPrintable());
                    out2.writeBoolean(plugin.isDefer());
                }
            }
        }
    }

    public void loadCacheFiles(Enumeration<URL> resources) throws IOException {
        this.categories.clear();
        while (resources.hasMoreElements()) {
            URL url2 = resources.nextElement();
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(url2.openStream()));){
                int count2 = in.readInt();
                for (int i = 0; i < count2; ++i) {
                    String category = in.readUTF();
                    Map<String, PluginEntry> m4 = this.getCategory(category);
                    int entries2 = in.readInt();
                    for (int j = 0; j < entries2; ++j) {
                        String key2 = in.readUTF();
                        String className = in.readUTF();
                        String name = in.readUTF();
                        boolean printable = in.readBoolean();
                        boolean defer = in.readBoolean();
                        m4.computeIfAbsent(key2, k -> {
                            PluginEntry entry = new PluginEntry();
                            entry.setKey((String)k);
                            entry.setClassName(className);
                            entry.setName(name);
                            entry.setPrintable(printable);
                            entry.setDefer(defer);
                            entry.setCategory(category);
                            return entry;
                        });
                    }
                }
            }
        }
    }

    public int size() {
        return this.categories.size();
    }
}

