/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OsgiServiceLocator {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final boolean OSGI_AVAILABLE = OsgiServiceLocator.checkOsgiAvailable();

    private static boolean checkOsgiAvailable() {
        try {
            Class<?> clazz = Class.forName("org.osgi.framework.FrameworkUtil");
            return clazz.getMethod("getBundle", Class.class).invoke(null, OsgiServiceLocator.class) != null;
        }
        catch (ClassNotFoundException | LinkageError | NoSuchMethodException e) {
            return false;
        }
        catch (Throwable error) {
            LOGGER.error("Unknown error checking OSGI environment.", error);
            return false;
        }
    }

    public static boolean isAvailable() {
        return OSGI_AVAILABLE;
    }

    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup2) {
        return OsgiServiceLocator.loadServices(serviceType, lookup2, true);
    }

    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup2, boolean verbose) {
        block6: {
            Class<?> lookupClass = Objects.requireNonNull(lookup2, "lookup").lookupClass();
            Bundle bundle = FrameworkUtil.getBundle(Objects.requireNonNull(lookupClass, "lookupClass"));
            if (bundle != null) {
                BundleContext ctx = bundle.getBundleContext();
                if (ctx == null) {
                    if (verbose) {
                        StatusLogger.getLogger().error("Unable to load OSGI services: The bundle has no valid BundleContext for serviceType = {}, lookup = {}, lookupClass = {}, bundle = {}", (Object)serviceType, (Object)lookup2, (Object)lookupClass, (Object)bundle);
                    }
                } else {
                    try {
                        return ctx.getServiceReferences(serviceType, null).stream().map(arg_0 -> ((BundleContext)ctx).getService(arg_0));
                    }
                    catch (Throwable e) {
                        if (!verbose) break block6;
                        StatusLogger.getLogger().error("Unable to load OSGI services for service {}", (Object)serviceType, (Object)e);
                    }
                }
            }
        }
        return Stream.empty();
    }
}

