/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpFieldPreEncoder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.compression.HuffmanEncoder;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http2.hpack.HpackContext;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.util.BufferUtil;

public class HpackFieldPreEncoder
implements HttpFieldPreEncoder {
    @Override
    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public byte[] getEncodedField(HttpHeader header, String name, String value2) {
        int bits;
        boolean huffman;
        boolean notIndexed = HpackEncoder.DO_NOT_INDEX.contains((Object)header);
        ByteBuffer buffer = BufferUtil.allocate(name.length() + value2.length() + 10);
        BufferUtil.clearToFill(buffer);
        if (notIndexed) {
            boolean neverIndex = HpackEncoder.NEVER_INDEX.contains((Object)header);
            huffman = !HpackEncoder.DO_NOT_HUFFMAN.contains((Object)header);
            buffer.put(neverIndex ? (byte)16 : 0);
            bits = 4;
        } else if (header == HttpHeader.CONTENT_LENGTH && value2.length() > 1) {
            buffer.put((byte)0);
            huffman = true;
            bits = 4;
        } else {
            buffer.put((byte)64);
            huffman = !HpackEncoder.DO_NOT_HUFFMAN.contains((Object)header);
            bits = 6;
        }
        int nameIdx = HpackContext.staticIndex(header);
        if (nameIdx > 0) {
            NBitIntegerEncoder.encode(buffer, bits, nameIdx);
        } else {
            buffer.put((byte)-128);
            NBitIntegerEncoder.encode(buffer, 7, HuffmanEncoder.octetsNeededLowerCase(name));
            HuffmanEncoder.encodeLowerCase(buffer, name);
        }
        HpackEncoder.encodeValue(buffer, huffman, value2);
        BufferUtil.flipToFlush(buffer, 0);
        return BufferUtil.toArray(buffer);
    }
}

