/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client;

import org.eclipse.paho.mqttv5.client.MqttToken;
import org.eclipse.paho.mqttv5.client.internal.ClientComms;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttPersistenceException;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;

public class MqttTopic {
    private ClientComms comms;
    private String name;

    public MqttTopic(String name, ClientComms comms) {
        this.comms = comms;
        this.name = name;
    }

    public MqttToken publish(byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(message);
    }

    public MqttToken publish(MqttMessage message) throws MqttException, MqttPersistenceException {
        MqttToken token2 = new MqttToken(this.comms.getClient().getClientId());
        token2.internalTok.setDeliveryToken(true);
        token2.setMessage(message);
        this.comms.sendNoWait(this.createPublish(message, new MqttProperties()), token2);
        token2.internalTok.waitUntilSent();
        return token2;
    }

    public String getName() {
        return this.name;
    }

    private MqttPublish createPublish(MqttMessage message, MqttProperties properties2) {
        return new MqttPublish(this.getName(), message, properties2);
    }

    public String toString() {
        return this.getName();
    }
}

