/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.paho.mqttv5.client.IMqttMessageListener;
import org.eclipse.paho.mqttv5.client.MqttActionListener;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.client.MqttToken;
import org.eclipse.paho.mqttv5.client.internal.ClientComms;
import org.eclipse.paho.mqttv5.client.internal.ClientState;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttAuth;
import org.eclipse.paho.mqttv5.common.packet.MqttDisconnect;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPubAck;
import org.eclipse.paho.mqttv5.common.packet.MqttPubComp;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.util.MqttTopicValidator;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME = CommsCallback.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private static final int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private MqttCallback reconnectInternalCallback;
    private HashMap<Integer, IMqttMessageListener> callbackMap;
    private HashMap<String, Integer> callbackTopicMap;
    private HashMap<Integer, Integer> subscriptionIdMap;
    private AtomicInteger messageHandlerId = new AtomicInteger(0);
    private ClientComms clientComms;
    private ArrayList<MqttPublish> messageQueue;
    private ArrayList<MqttToken> completeQueue;
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private Thread callbackThread;
    private String threadName;
    private Future<?> callbackFuture;
    private final Object workAvailable = new Object();
    private final Object spaceAvailable = new Object();
    private ClientState clientState;
    private boolean manualAcks = false;

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new ArrayList(10);
        this.completeQueue = new ArrayList(10);
        this.callbackMap = new HashMap();
        this.callbackTopicMap = new HashMap();
        this.subscriptionIdMap = new HashMap();
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        var3_3 = this.lifecycle;
        synchronized (var3_3) {
            if (this.current_state == State.STOPPED) {
                var4_4 = this.workAvailable;
                synchronized (var4_4) {
                    this.messageQueue.clear();
                    this.completeQueue.clear();
                }
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.callbackFuture = executorService.submit(this);
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl28
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception v2) {}
lbl28:
            // 3 sources

        } while (!this.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stop() {
        block13: {
            block14: {
                var1_1 = this.lifecycle;
                synchronized (var1_1) {
                    if (this.callbackFuture != null) {
                        this.callbackFuture.cancel(true);
                    }
                }
                if (!this.isRunning()) break block13;
                this.log.fine(CommsCallback.CLASS_NAME, "stop", "700");
                var1_1 = this.lifecycle;
                synchronized (var1_1) {
                    this.target_state = State.STOPPED;
                }
                if (Thread.currentThread().equals(this.callbackThread)) break block14;
                var1_1 = this.workAvailable;
                synchronized (var1_1) {
                    this.log.fine(CommsCallback.CLASS_NAME, "stop", "701");
                    this.workAvailable.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[2, 6] lbl29 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl35
                }
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception v3) {}
                    this.clientState.notifyQueueLock();
lbl35:
                    // 2 sources

                } while (this.isRunning());
            }
            this.callbackThread = null;
            this.log.fine(CommsCallback.CLASS_NAME, "stop", "703");
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    public void setReconnectCallback(MqttCallback callback2) {
        this.reconnectInternalCallback = callback2;
    }

    public void setManualAcks(boolean manualAcks) {
        this.manualAcks = manualAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.callbackThread = Thread.currentThread();
        this.callbackThread.setName(this.threadName);
        var1_1 = this.lifecycle;
        synchronized (var1_1) {
            this.current_state = State.RUNNING;
            // MONITOREXIT @DISABLED, blocks:[0, 11] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl87
        }
        do {
            try {
                try {
                    try {
                        var1_1 = this.workAvailable;
                        synchronized (var1_1) {
                            if (this.isRunning() && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                                this.log.fine(CommsCallback.CLASS_NAME, "run", "704");
                                this.workAvailable.wait();
                            }
                        }
                    }
                    catch (InterruptedException v2) {}
                    if (this.isRunning()) {
                        token = null;
                        var2_3 = this.workAvailable;
                        synchronized (var2_3) {
                            if (!this.completeQueue.isEmpty()) {
                                token = this.completeQueue.get(0);
                                this.completeQueue.remove(0);
                            }
                        }
                        if (token != null) {
                            this.handleActionComplete(token);
                        }
                        message = null;
                        var3_4 = this.workAvailable;
                        synchronized (var3_4) {
                            if (!this.messageQueue.isEmpty()) {
                                message = this.messageQueue.get(0);
                                this.messageQueue.remove(0);
                            }
                        }
                        if (message != null) {
                            this.handleMessage(message);
                        }
                    }
                    if (this.isQuiescing()) {
                        this.clientState.checkQuiesceLock();
                    }
                }
                catch (Throwable ex) {
                    this.log.fine(CommsCallback.CLASS_NAME, "run", "714", null, ex);
                    this.clientComms.shutdownConnection(null, new MqttException(ex), null);
                    var5_5 = this.spaceAvailable;
                    synchronized (var5_5) {
                        this.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                        this.spaceAvailable.notifyAll();
                        continue;
                    }
                }
            }
            catch (Throwable var4_6) {
                var5_5 = this.spaceAvailable;
                synchronized (var5_5) {
                    this.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                    this.spaceAvailable.notifyAll();
                }
                throw var4_6;
            }
            var5_5 = this.spaceAvailable;
            synchronized (var5_5) {
                this.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                this.spaceAvailable.notifyAll();
            }
lbl87:
            // 3 sources

        } while (this.isRunning());
        var1_1 = this.lifecycle;
        synchronized (var1_1) {
            this.current_state = State.STOPPED;
        }
        this.callbackThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token2) throws MqttException {
        MqttToken mqttToken = token2;
        synchronized (mqttToken) {
            this.log.fine(CLASS_NAME, "handleActionComplete", "705", new Object[]{token2.internalTok.getKey()});
            if (token2.isComplete()) {
                this.clientState.notifyComplete(token2);
            }
            token2.internalTok.notifyComplete();
            if (!token2.internalTok.isNotified()) {
                if (this.mqttCallback != null && token2.internalTok.isDeliveryToken() && token2.isComplete()) {
                    try {
                        this.mqttCallback.deliveryComplete(token2);
                    }
                    catch (Throwable ex) {
                        this.log.fine(CLASS_NAME, "handleActionComplete", "726", new Object[]{ex});
                    }
                }
                this.fireActionEvent(token2);
            }
            if (token2.isComplete() && (token2.internalTok.isDeliveryToken() || token2.getActionCallback() instanceof MqttActionListener)) {
                token2.internalTok.setNotified(true);
            }
        }
    }

    public void connectionLost(MqttException cause, MqttDisconnect message) {
        try {
            MqttDisconnectResponse disconnectResponse;
            if (this.mqttCallback != null && message != null) {
                this.log.fine(CLASS_NAME, "connectionLost", "722", new Object[]{message.toString()});
                disconnectResponse = new MqttDisconnectResponse(message.getReturnCode(), message.getProperties().getReasonString(), (ArrayList)message.getProperties().getUserProperties(), message.getProperties().getServerReference());
                this.mqttCallback.disconnected(disconnectResponse);
            } else if (this.mqttCallback != null && cause != null) {
                this.log.fine(CLASS_NAME, "connectionLost", "708", new Object[]{cause});
                disconnectResponse = new MqttDisconnectResponse(cause);
                this.mqttCallback.disconnected(disconnectResponse);
            }
            if (this.reconnectInternalCallback != null && cause != null) {
                disconnectResponse = new MqttDisconnectResponse(cause);
                this.reconnectInternalCallback.disconnected(disconnectResponse);
            }
        }
        catch (Throwable t2) {
            this.log.fine(CLASS_NAME, "connectionLost", "720", new Object[]{t2});
        }
    }

    public void fireActionEvent(MqttToken token2) {
        MqttActionListener asyncCB;
        if (token2 != null && (asyncCB = token2.getActionCallback()) != null) {
            if (token2.getException() == null) {
                this.log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token2.internalTok.getKey()});
                asyncCB.onSuccess(token2);
            } else {
                this.log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token2.internalTok.getKey()});
                asyncCB.onFailure(token2, token2.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageArrived(MqttPublish sendMessage) {
        if (this.mqttCallback == null) {
            if (this.callbackMap.size() <= 0) return;
        }
        Object object = this.spaceAvailable;
        synchronized (object) {
            while (this.isRunning() && !this.isQuiescing() && this.messageQueue.size() >= 10) {
                try {
                    this.log.fine(CLASS_NAME, "messageArrived", "709");
                    this.spaceAvailable.wait(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.isQuiescing()) return;
        object = this.workAvailable;
        synchronized (object) {
            this.messageQueue.add(sendMessage);
            this.log.fine(CLASS_NAME, "messageArrived", "710");
            this.workAvailable.notifyAll();
            return;
        }
    }

    public void authMessageReceived(MqttAuth authMessage) {
        String methodName = "authMessageReceived";
        if (this.mqttCallback != null) {
            try {
                this.mqttCallback.authPacketArrived(authMessage.getReturnCode(), authMessage.getProperties());
            }
            catch (Throwable ex) {
                this.log.fine(CLASS_NAME, methodName, "727", new Object[]{ex});
            }
        }
    }

    public void mqttErrorOccurred(MqttException exception) {
        this.log.warning(CLASS_NAME, "mqttErrorOccurred", "721", new Object[]{exception.getMessage()});
        if (this.mqttCallback != null) {
            try {
                this.mqttCallback.mqttErrorOccurred(exception);
            }
            catch (Exception ex) {
                this.log.fine(CLASS_NAME, "mqttErrorOccurred", "724", new Object[]{ex});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.RUNNING) {
                this.current_state = State.QUIESCING;
            }
        }
        object = this.spaceAvailable;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "quiesce", "711");
            this.spaceAvailable.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areQueuesEmpty() {
        Object object = this.workAvailable;
        synchronized (object) {
            return this.completeQueue.isEmpty() && this.messageQueue.isEmpty();
        }
    }

    public boolean isQuiesced() {
        return this.isQuiescing() && this.areQueuesEmpty();
    }

    private void handleMessage(MqttPublish publishMessage) throws Exception {
        String destName = publishMessage.getTopicName();
        this.log.fine(CLASS_NAME, "handleMessage", "713", new Object[]{publishMessage.getMessageId(), destName});
        this.deliverMessage(destName, publishMessage.getMessageId(), publishMessage.getMessage());
        if (!this.manualAcks && publishMessage.getMessage().getQos() == 1) {
            this.clientComms.internalSend(new MqttPubAck(0, publishMessage.getMessageId(), new MqttProperties()), new MqttToken(this.clientComms.getClient().getClientId()));
        }
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        if (qos == 1) {
            this.clientComms.internalSend(new MqttPubAck(0, messageId, new MqttProperties()), new MqttToken(this.clientComms.getClient().getClientId()));
        } else if (qos == 2) {
            this.clientComms.deliveryComplete(messageId);
            MqttPubComp pubComp = new MqttPubComp(0, messageId, new MqttProperties());
            this.log.info(CLASS_NAME, "messageArrivedComplete", "723", new Object[]{pubComp.toString()});
            this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken token2) {
        if (this.isRunning()) {
            Object object = this.workAvailable;
            synchronized (object) {
                this.completeQueue.add(token2);
                this.log.fine(CLASS_NAME, "asyncOperationComplete", "715", new Object[]{token2.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token2);
        }
        catch (MqttException ex) {
            this.log.fine(CLASS_NAME, "asyncOperationComplete", "719", null, ex);
            this.clientComms.shutdownConnection(null, new MqttException(ex), null);
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }

    public void setMessageListener(Integer subscriptionId, String topicFilter, IMqttMessageListener messageListener) {
        int internalId = this.messageHandlerId.incrementAndGet();
        this.callbackMap.put(internalId, messageListener);
        this.callbackTopicMap.put(topicFilter, internalId);
        if (subscriptionId != null) {
            this.subscriptionIdMap.put(subscriptionId, internalId);
        }
    }

    public void removeMessageListener(String topicFilter) {
        Integer callbackId = this.callbackTopicMap.get(topicFilter);
        this.callbackMap.remove(callbackId);
        this.callbackTopicMap.remove(topicFilter);
        for (Map.Entry<Integer, Integer> entry : this.subscriptionIdMap.entrySet()) {
            if (!entry.getValue().equals(callbackId)) continue;
            this.subscriptionIdMap.remove(entry.getKey());
        }
    }

    public void removeMessageListener(Integer subscriptionId) {
        Integer callbackId = this.subscriptionIdMap.get(subscriptionId);
        this.subscriptionIdMap.remove(callbackId);
        this.callbackMap.remove(callbackId);
        for (Map.Entry<String, Integer> entry : this.callbackTopicMap.entrySet()) {
            if (!entry.getValue().equals(callbackId)) continue;
            this.callbackTopicMap.remove(entry.getKey());
        }
    }

    public void removeMessageListeners() {
        this.callbackMap.clear();
        this.subscriptionIdMap.clear();
        this.callbackTopicMap.clear();
    }

    protected boolean deliverMessage(String topicName, int messageId, MqttMessage aMessage) throws Exception {
        boolean delivered = false;
        String methodName = "deliverMessage";
        if (aMessage.getProperties().getSubscriptionIdentifiers().isEmpty()) {
            for (Map.Entry<String, Integer> entry : this.callbackTopicMap.entrySet()) {
                if (!MqttTopicValidator.isMatched(entry.getKey(), topicName)) continue;
                aMessage.setId(messageId);
                this.callbackMap.get(entry.getValue()).messageArrived(topicName, aMessage);
                delivered = true;
            }
        } else {
            for (Integer subId : aMessage.getProperties().getSubscriptionIdentifiers()) {
                if (!this.subscriptionIdMap.containsKey(subId)) continue;
                Integer callbackId = this.subscriptionIdMap.get(subId);
                aMessage.setId(messageId);
                this.callbackMap.get(callbackId).messageArrived(topicName, aMessage);
                delivered = true;
            }
        }
        if (this.mqttCallback != null && !delivered) {
            aMessage.setId(messageId);
            try {
                this.mqttCallback.messageArrived(topicName, aMessage);
            }
            catch (Exception ex) {
                this.log.fine(CLASS_NAME, methodName, "725", new Object[]{ex});
            }
            delivered = true;
        }
        return delivered;
    }

    public boolean doesSubscriptionIdentifierExist(int subscriptionIdentifier) {
        return this.subscriptionIdMap.containsKey(subscriptionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean result2;
        Object object = this.lifecycle;
        synchronized (object) {
            result2 = (this.current_state == State.RUNNING || this.current_state == State.QUIESCING) && this.target_state == State.RUNNING;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiescing() {
        boolean result2;
        Object object = this.lifecycle;
        synchronized (object) {
            result2 = this.current_state == State.QUIESCING;
        }
        return result2;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        QUIESCING;

    }
}

