/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.paho.mqttv5.client.MqttToken;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;

public class CommsTokenStore {
    private static final String CLASS_NAME = CommsTokenStore.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private final Hashtable<String, MqttToken> tokens;
    private String logContext;
    private MqttException closedResponse = null;

    public CommsTokenStore(String logContext) {
        this.log.setResourceName(logContext);
        this.tokens = new Hashtable();
        this.logContext = logContext;
        this.log.fine(CLASS_NAME, "<Init>", "308");
    }

    public MqttToken getToken(MqttWireMessage message) {
        String key2 = message.getKey();
        return this.tokens.get(key2);
    }

    public MqttToken getToken(String key2) {
        return this.tokens.get(key2);
    }

    public MqttToken removeToken(MqttWireMessage message) {
        if (message != null) {
            return this.removeToken(message.getKey());
        }
        return null;
    }

    public MqttToken removeToken(String key2) {
        this.log.fine(CLASS_NAME, "removeToken", "306", new Object[]{key2});
        if (key2 != null) {
            return this.tokens.remove(key2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttToken restoreToken(MqttPublish message) {
        MqttToken token2;
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            String key2 = Integer.valueOf(message.getMessageId()).toString();
            if (this.tokens.containsKey(key2)) {
                token2 = this.tokens.get(key2);
                this.log.fine(CLASS_NAME, "restoreToken", "302", new Object[]{key2, message, token2});
            } else {
                token2 = new MqttToken(this.logContext);
                token2.internalTok.setDeliveryToken(true);
                token2.internalTok.setKey(key2);
                this.tokens.put(key2, token2);
                this.log.fine(CLASS_NAME, "restoreToken", "303", new Object[]{key2, message, token2});
            }
        }
        return token2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToken(MqttToken token2, MqttWireMessage message) throws MqttException {
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            if (this.closedResponse != null) {
                throw this.closedResponse;
            }
            String key2 = message.getKey();
            this.log.fine(CLASS_NAME, "saveToken", "300", new Object[]{key2, message});
            this.saveToken(token2, key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToken(MqttToken token2, String key2) {
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "saveToken", "307", new Object[]{key2, token2.toString()});
            token2.internalTok.setKey(key2);
            this.tokens.put(key2, token2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quiesce(MqttException quiesceResponse) {
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "quiesce", "309", new Object[]{quiesceResponse});
            this.closedResponse = quiesceResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "open", "310");
            this.closedResponse = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttToken[] getOutstandingDelTokens() {
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "getOutstandingDelTokens", "311");
            Vector<MqttToken> list = new Vector<MqttToken>();
            Enumeration<MqttToken> enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken token2 = enumeration.nextElement();
                if (token2 == null || !token2.internalTok.isDeliveryToken() || token2.internalTok.isNotified()) continue;
                list.addElement(token2);
            }
            MqttToken[] result2 = new MqttToken[list.size()];
            return list.toArray(result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<MqttToken> getOutstandingTokens() {
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "getOutstandingTokens", "312");
            Vector<MqttToken> list = new Vector<MqttToken>();
            Enumeration<MqttToken> enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken token2 = enumeration.nextElement();
                if (token2 == null) continue;
                list.addElement(token2);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.log.fine(CLASS_NAME, "clear", "305", new Object[]{this.tokens.size()});
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            this.tokens.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            return this.tokens.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String lineSep = System.getProperty("line.separator", "\n");
        StringBuffer toks = new StringBuffer();
        Hashtable<String, MqttToken> hashtable = this.tokens;
        synchronized (hashtable) {
            Enumeration<MqttToken> enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken token2 = enumeration.nextElement();
                toks.append("{" + token2.internalTok + "}" + lineSep);
            }
            return toks.toString();
        }
    }
}

